/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories;

import at.chrl.nutils.ClassUtils;
import at.chrl.nutils.CollectionUtils;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.jpa.HibernateEntityManager;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Scope(value="singleton")
public abstract class GenericRepository<T> {
    private final Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private String idFieldName;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    protected EntityManager entityManager;

    public Class<T> getType() {
        return this.persistentClass;
    }

    protected String getIdFieldName() {
        return this.idFieldName;
    }

    protected Session getSession() {
        return ((HibernateEntityManager)this.entityManager.unwrap(HibernateEntityManager.class)).getSession();
    }

    @PostConstruct
    private void setIdFieldName() {
        this.idFieldName = this.getSession().getSessionFactory().getClassMetadata(this.persistentClass).getIdentifierPropertyName();
    }

    @Transactional
    public T getById(Object id) {
        return (T)this.entityManager.find(this.getType(), id);
    }

    public Collection<T> getByIds(Object ... ids) {
        return this.getByIds(Arrays.asList(ids));
    }

    @Transactional
    public Collection<T> getByIds(Collection<Object> ids) {
        if (Objects.isNull(this.idFieldName)) {
            return Collections.emptyList();
        }
        return this.getSession().createCriteria(this.persistentClass).add(Restrictions.in((String)this.idFieldName, ids)).list();
    }

    @Transactional
    public T persist(T entity) {
        this.entityManager.persist(entity);
        return entity;
    }

    @Transactional
    public T remove(T entity) {
        this.entityManager.remove(entity);
        return entity;
    }

    @Transactional
    public T refresh(T entity) {
        this.entityManager.refresh(entity);
        return entity;
    }

    @Transactional
    public T merge(T entity) {
        this.entityManager.merge(entity);
        return entity;
    }

    @Transactional
    public T save(T entity) {
        this.getSession().save(entity);
        return entity;
    }

    @Transactional
    public T saveOrUpdate(T entity) {
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Transactional
    public T mergeWithSession(T entity) {
        this.getSession().merge(entity);
        return entity;
    }

    @Transactional
    public T persistWithSession(T entity) {
        this.getSession().persist(entity);
        return entity;
    }

    @Transactional
    public Map<Date, T> getOlderVersions(Object id) {
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisions = reader.getRevisions(this.getType(), id).stream().collect(Collectors.toList());
        List collect = revisions.stream().map(n -> reader.find(this.getType(), id, n)).collect(Collectors.toList());
        List dates = revisions.stream().map(arg_0 -> ((AuditReader)reader).getRevisionDate(arg_0)).collect(Collectors.toList());
        Map returnMe = CollectionUtils.newMap();
        int to = Math.min(collect.size(), dates.size());
        for (int i = 0; i < to; ++i) {
            returnMe.put(dates.get(i), collect.get(i));
        }
        return returnMe;
    }

    public Collection<T> getAll(int maxResults) {
        Query q = this.entityManager.createQuery("select e from " + this.getType().getSimpleName() + " e");
        if (maxResults > 0) {
            q = q.setMaxResults(maxResults);
        }
        return q.getResultList();
    }

    public long count() {
        Query q = this.entityManager.createQuery("select count(e) from " + this.getType().getSimpleName() + " e");
        return (Long)q.getResultList().get(0);
    }

    public Collection<T> getLast(int count) {
        return this.entityManager.createQuery("select e from " + this.getType().getSimpleName() + " e order by e." + this.idFieldName + " desc").setMaxResults(count).getResultList();
    }

    public Collection<T> executeQuery(Query q, int maxResults) {
        if (maxResults > 0) {
            q = q.setMaxResults(maxResults);
        }
        return q.getResultList();
    }

    public Collection<T> executeHQLQuery(String query, int maxResults) {
        return this.executeQuery(this.entityManager.createQuery(query), maxResults);
    }

    public Collection<T> executeSQLQuery(String query, int maxResults) {
        return this.executeQuery(this.entityManager.createNativeQuery(query), maxResults);
    }

    public Collection<T> executeNamedQuery(String query, int maxResults) {
        return this.executeQuery(this.entityManager.createNamedQuery(query), maxResults);
    }

    public Collection<T> executeHQLQuery(String query) {
        return this.executeHQLQuery(query, 0);
    }

    public Collection<T> executeSQLQuery(String query) {
        return this.executeSQLQuery(query, 0);
    }

    public Collection<T> executeNamedQuery(String query) {
        return this.executeNamedQuery(query, 0);
    }

    public String toString() {
        return ClassUtils.getString((Object)this, (Function[])new Function[]{new Function<GenericRepository<T>, String>(){

            @Override
            public String apply(GenericRepository<T> t) {
                return t.getType().getSimpleName();
            }
        }});
    }
}

