/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.jms;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.util.Enumeration;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;

@EnableJms
@Configuration
public class JmsConfig {
    @Bean(destroyMethod="stop")
    public BrokerService getActiveMQBrokerService() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                if (!(i instanceof Inet4Address)) continue;
                TransportConnector con = new TransportConnector();
                con.setUri(new URI("tcp://" + i.getHostAddress() + ":61616"));
                broker.addConnector(con);
            }
        }
        broker.start();
        return broker;
    }

    @Bean
    public JmsListenerContainerFactory<?> myJmsContainerFactory(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof ActiveMQConnectionFactory) {
            ActiveMQConnectionFactory activeMqConnectionFactory = (ActiveMQConnectionFactory)connectionFactory;
            activeMqConnectionFactory.setOptimizeAcknowledge(true);
            System.out.println("tweak me");
        }
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTypeIdPropertyName("jtype");
        factory.setMessageConverter((MessageConverter)converter);
        factory.setConnectionFactory(connectionFactory);
        factory.setConcurrency("3-3000");
        factory.setPubSubDomain(Boolean.valueOf(false));
        factory.setReplyPubSubDomain(Boolean.valueOf(false));
        return factory;
    }
}

