/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.database.dao;

import at.chrl.database.DatabaseConfig;
import at.chrl.database.DatabaseFactory;
import at.chrl.database.dao.DAO;
import at.chrl.database.dao.DAOAlreadyRegisteredException;
import at.chrl.database.dao.DAOLoader;
import at.chrl.database.dao.DAONotFoundException;
import at.chrl.rebellion.classlistener.AggregatedClassListener;
import at.chrl.rebellion.classlistener.ClassListener;
import at.chrl.rebellion.classlistener.OnClassLoadUnloadListener;
import at.chrl.rebellion.classlistener.ScheduledTaskClassListener;
import at.chrl.rebellion.scriptmanager.ScriptManager;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOManager {
    private static final Logger log = LoggerFactory.getLogger(DAOManager.class);
    private static final Map<String, DAO> daoMap = new HashMap<String, DAO>();
    private static ScriptManager scriptManager;

    public static void init() {
        try {
            scriptManager = new ScriptManager();
            AggregatedClassListener acl = new AggregatedClassListener();
            acl.addClassListener((ClassListener)new OnClassLoadUnloadListener());
            acl.addClassListener((ClassListener)new ScheduledTaskClassListener());
            acl.addClassListener((ClassListener)new DAOLoader());
            scriptManager.setGlobalClassListener((ClassListener)acl);
            scriptManager.load(DatabaseConfig.DATABASE_SCRIPTCONTEXT_DESCRIPTOR);
        }
        catch (RuntimeException e) {
            throw new Error(e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw new Error("Can't load database script context: " + DatabaseConfig.DATABASE_SCRIPTCONTEXT_DESCRIPTOR, e);
        }
        catch (JAXBException e) {
            throw new Error("Can't compile database handlers - check your MySQL5 implementations", e);
        }
        catch (Exception e) {
            throw new Error("A fatal error occured during loading or compiling the database handlers", e);
        }
        log.info("Loaded " + daoMap.size() + " DAO implementations.");
    }

    public static void shutdown() {
        scriptManager.shutdown();
        daoMap.clear();
        scriptManager = null;
    }

    public static <T extends DAO> T getDAO(Class<T> clazz) throws DAONotFoundException {
        DAO result = daoMap.get(clazz.getName());
        if (result == null) {
            String s = "DAO for class " + clazz.getSimpleName() + " not implemented";
            log.error(s);
            throw new DAONotFoundException(s);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDAO(Class<? extends DAO> daoClass) throws DAOAlreadyRegisteredException, IllegalAccessException, InstantiationException {
        DAO dao = daoClass.newInstance();
        if (!dao.supports(DatabaseFactory.getDatabaseName(), DatabaseFactory.getDatabaseMajorVersion(), DatabaseFactory.getDatabaseMinorVersion())) {
            return;
        }
        Class<DAOManager> clazz = DAOManager.class;
        synchronized (DAOManager.class) {
            DAO oldDao = daoMap.get(dao.getClassName());
            if (oldDao != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("DAO with className ").append(dao.getClassName()).append(" is used by ");
                sb.append(oldDao.getClass().getName()).append(". Can't override with ");
                sb.append(daoClass.getName()).append(".");
                String s = sb.toString();
                log.error(s);
                throw new DAOAlreadyRegisteredException(s);
            }
            daoMap.put(dao.getClassName(), dao);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (log.isDebugEnabled()) {
                log.debug("DAO " + dao.getClassName() + " was successfuly registered.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterDAO(Class<? extends DAO> daoClass) {
        Class<DAOManager> clazz = DAOManager.class;
        synchronized (DAOManager.class) {
            for (DAO dao : daoMap.values()) {
                if (dao.getClass() != daoClass) continue;
                daoMap.remove(dao.getClassName());
                if (!log.isDebugEnabled()) break;
                log.debug("DAO " + dao.getClassName() + " was successfuly unregistered.");
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private DAOManager() {
    }
}

