/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.database.dao;

import at.chrl.database.dao.DAO;
import at.chrl.database.dao.DAOManager;
import at.chrl.database.dao.DisabledDAO;
import at.chrl.nutils.ClassUtils;
import at.chrl.rebellion.classlistener.ClassListener;
import java.lang.reflect.Modifier;

public class DAOLoader
implements ClassListener {
    public void postLoad(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!this.isValidDAO(clazz)) continue;
            try {
                DAOManager.registerDAO(clazz);
            }
            catch (Exception e) {
                throw new Error("Can't register DAO class", e);
            }
        }
    }

    public void preUnload(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!this.isValidDAO(clazz)) continue;
            try {
                DAOManager.unregisterDAO(clazz);
            }
            catch (Exception e) {
                throw new Error("Can't unregister DAO class", e);
            }
        }
    }

    public boolean isValidDAO(Class<?> clazz) {
        if (!ClassUtils.isSubclass(clazz, DAO.class)) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            return false;
        }
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        return !clazz.isAnnotationPresent(DisabledDAO.class);
    }
}

