/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.transformers;

import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.TransformationException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTransformer
implements PropertyTransformer<Date> {
    public static final DateTransformer SHARED_INSTANCE = new DateTransformer();
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_AND_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd kk:mm");

    @Override
    public Date transform(String value, Field field) throws TransformationException {
        try {
            return DATE_AND_TIME_FORMAT.parse(value);
        }
        catch (ParseException e) {
            try {
                return DATE_FORMAT.parse(value);
            }
            catch (ParseException e1) {
                throw new TransformationException(e1);
            }
        }
    }
}

