/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.transformers;

import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.TransformationException;
import java.lang.reflect.Field;

public class CharTransformer
implements PropertyTransformer<Character> {
    public static final CharTransformer SHARED_INSTANCE = new CharTransformer();

    @Override
    public Character transform(String value, Field field) throws TransformationException {
        try {
            char[] chars = value.toCharArray();
            if (chars.length > 1) {
                throw new TransformationException("To many characters in the value");
            }
            return Character.valueOf(chars[0]);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }
}

