/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.printer;

import at.chrl.logging.Logger;
import at.chrl.nutils.FileUtil;
import at.chrl.nutils.JVMInfoUtil;
import at.chrl.nutils.configuration.IConfigPrinter;
import at.chrl.nutils.configuration.Property;
import at.chrl.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public class PropertyFileStreamPrinter
implements IConfigPrinter {
    public static final Logger log = new Logger();
    private final File targetFile;
    private boolean recreated = false;

    public PropertyFileStreamPrinter(File targetFile) {
        this.targetFile = targetFile;
    }

    @Override
    public <T> void printConfigField(Property property, String currentValue, Class<T> annotatedType) {
        if (!this.recreated) {
            FileUtil.recreate((File)this.targetFile);
            this.targetFile.setReadable(true, false);
            this.targetFile.setWritable(true, false);
            this.recreated = true;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.targetFile.toPath(), Charset.forName("UTF-8"), StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            writer.write("# " + JVMInfoUtil.printSection((String)property.key()) + System.lineSeparator());
            writer.write("# Description:" + System.lineSeparator());
            writer.write("# " + StringUtils.insertRepetitive((String)property.description(), (int)(102 - (property.key().length() + 5)), (String)"\n# ") + System.lineSeparator());
            writer.write("# " + System.lineSeparator());
            if (property.examples().length > 0) {
                writer.write("# Examples:" + System.lineSeparator());
                for (String example : property.examples()) {
                    writer.write("# " + example + System.lineSeparator());
                }
                writer.write("# " + System.lineSeparator());
            } else if (annotatedType.isEnum()) {
                writer.write("# Valid Examples:" + System.lineSeparator());
                for (String example : annotatedType.getEnumConstants()) {
                    writer.write("# " + example.toString() + System.lineSeparator());
                }
                writer.write("# " + System.lineSeparator());
            }
            writer.write("# Default Value: " + property.defaultValue() + System.lineSeparator());
            writer.write(property.key() + "=" + currentValue + System.lineSeparator());
            writer.write(System.lineSeparator());
        }
        catch (Exception e) {
            log.error((Object)("Exception during property exportation: " + this.targetFile.getAbsolutePath() + " | " + e.getMessage()), new Throwable[]{e});
        }
    }
}

