/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.printer;

import at.chrl.logging.Logger;
import at.chrl.nutils.JVMInfoUtil;
import at.chrl.nutils.configuration.IConfigPrinter;
import at.chrl.nutils.configuration.Property;
import at.chrl.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamPrinter
implements IConfigPrinter {
    private static final Logger log = new Logger();
    final OutputStream os;

    public OutputStreamPrinter(OutputStream os) {
        this.os = os;
    }

    @Override
    public <T> void printConfigField(Property property, String currentValue, Class<T> annotatedType) {
        try {
            this.os.write(("# " + JVMInfoUtil.printSection((String)property.key()) + System.lineSeparator()).getBytes());
            this.os.write(("# Description:" + System.lineSeparator()).getBytes());
            this.os.write(("# " + StringUtils.insertRepetitive((String)property.description(), (int)(102 - (property.key().length() + 6)), (String)"\n# ") + System.lineSeparator()).getBytes());
            this.os.write(("# " + System.lineSeparator()).getBytes());
            if (property.examples().length > 0) {
                this.os.write(("# Examples:" + System.lineSeparator()).getBytes());
                for (String example : property.examples()) {
                    this.os.write(("# " + example + System.lineSeparator()).getBytes());
                }
                this.os.write(("# " + System.lineSeparator()).getBytes());
            } else if (annotatedType.isEnum()) {
                this.os.write(("# Valid Examples:" + System.lineSeparator()).getBytes());
                for (T example : annotatedType.getEnumConstants()) {
                    this.os.write(("# " + example.toString() + System.lineSeparator()).getBytes());
                }
                this.os.write(("# " + System.lineSeparator()).getBytes());
            }
            this.os.write(("# Default Value: " + property.defaultValue() + System.lineSeparator()).getBytes());
            this.os.write((property.key() + "=" + currentValue + System.lineSeparator()).getBytes());
            this.os.write(System.lineSeparator().getBytes());
            this.os.flush();
        }
        catch (IOException e) {
            log.error((Object)("Error writing to OutputStream: " + e.getMessage()), new Throwable[]{e});
        }
    }
}

