/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration;

import at.chrl.nutils.ClassUtils;
import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.TransformationException;
import at.chrl.nutils.configuration.transformers.ArrayTransformer;
import at.chrl.nutils.configuration.transformers.BiFunctionTransformer;
import at.chrl.nutils.configuration.transformers.BooleanTransformer;
import at.chrl.nutils.configuration.transformers.ByteTransformer;
import at.chrl.nutils.configuration.transformers.CharTransformer;
import at.chrl.nutils.configuration.transformers.ClassTransformer;
import at.chrl.nutils.configuration.transformers.DateTransformer;
import at.chrl.nutils.configuration.transformers.DoubleTransformer;
import at.chrl.nutils.configuration.transformers.EnumTransformer;
import at.chrl.nutils.configuration.transformers.FileTransformer;
import at.chrl.nutils.configuration.transformers.FloatTransformer;
import at.chrl.nutils.configuration.transformers.FunctionTransformer;
import at.chrl.nutils.configuration.transformers.InetSocketAddressTransformer;
import at.chrl.nutils.configuration.transformers.IntegerTransformer;
import at.chrl.nutils.configuration.transformers.LongTransformer;
import at.chrl.nutils.configuration.transformers.PatternTransformer;
import at.chrl.nutils.configuration.transformers.PrintStreamTransformer;
import at.chrl.nutils.configuration.transformers.ShortTransformer;
import at.chrl.nutils.configuration.transformers.StringTransformer;
import java.io.File;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;

public class PropertyTransformerFactory {
    public static PropertyTransformer newTransformer(Class clazzToTransform, Class<? extends PropertyTransformer> tc) throws TransformationException {
        if (tc == PropertyTransformer.class) {
            tc = null;
        }
        if (tc != null) {
            try {
                return tc.newInstance();
            }
            catch (Exception e) {
                throw new TransformationException("Can't instantiate property transfromer", e);
            }
        }
        if (clazzToTransform == Boolean.class || clazzToTransform == Boolean.TYPE) {
            return BooleanTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Byte.class || clazzToTransform == Byte.TYPE) {
            return ByteTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Character.class || clazzToTransform == Character.TYPE) {
            return CharTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Double.class || clazzToTransform == Double.TYPE) {
            return DoubleTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Float.class || clazzToTransform == Float.TYPE) {
            return FloatTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Integer.class || clazzToTransform == Integer.TYPE) {
            return IntegerTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Long.class || clazzToTransform == Long.TYPE) {
            return LongTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Short.class || clazzToTransform == Short.TYPE) {
            return ShortTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == String.class) {
            return StringTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform.isEnum()) {
            return EnumTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform.isArray()) {
            return ArrayTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Function.class || ClassUtils.isSubclass((Class)clazzToTransform, Function.class)) {
            return FunctionTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == BiFunction.class || ClassUtils.isSubclass((Class)clazzToTransform, BiFunction.class)) {
            return BiFunctionTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == File.class) {
            return FileTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Date.class) {
            return DateTransformer.SHARED_INSTANCE;
        }
        if (ClassUtils.isSubclass((Class)clazzToTransform, InetSocketAddress.class)) {
            return InetSocketAddressTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Pattern.class) {
            return PatternTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == Class.class) {
            return ClassTransformer.SHARED_INSTANCE;
        }
        if (clazzToTransform == PrintStream.class) {
            return PrintStreamTransformer.SHARED_INSTANCE;
        }
        throw new TransformationException("Transformer not found for class " + clazzToTransform.getName());
    }
}

