/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class PropertiesUtils {
    public static Properties load(String file) throws IOException {
        return PropertiesUtils.load(new File(file));
    }

    public static Properties load(File file) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)), 131072);
        Properties p = new Properties();
        p.load(br);
        br.close();
        return p;
    }

    public static Properties[] load(String ... files) throws IOException {
        Properties[] result = new Properties[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PropertiesUtils.load(files[i]);
        }
        return result;
    }

    public static Properties[] load(File ... files) throws IOException {
        Properties[] result = new Properties[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PropertiesUtils.load(files[i]);
        }
        return result;
    }

    public static Properties[] loadAllFromDirectory(String dir) throws IOException {
        return PropertiesUtils.loadAllFromDirectory(new File(dir), false);
    }

    public static Properties[] loadAllFromDirectory(File dir) throws IOException {
        return PropertiesUtils.loadAllFromDirectory(dir, false);
    }

    public static Properties[] loadAllFromDirectory(String dir, boolean recursive) throws IOException {
        return PropertiesUtils.loadAllFromDirectory(new File(dir), recursive);
    }

    public static Properties[] loadAllFromDirectory(File dir, boolean recursive) throws IOException {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)recursive);
        return PropertiesUtils.load(files.toArray(new File[files.size()]));
    }

    public static Properties filterEmtpyValues(Properties props) {
        Properties returnMe = new Properties();
        for (Map.Entry<Object, Object> iterable_element : props.entrySet()) {
            if (((String)iterable_element.getValue()).isEmpty()) continue;
            returnMe.setProperty((String)iterable_element.getKey(), (String)iterable_element.getValue());
        }
        return returnMe;
    }
}

