/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.WouldBlockException;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.ticks.TickListener;
import at.borkowski.spicej.ticks.TickSource;
import java.util.concurrent.atomic.AtomicInteger;

class RateHelper {
    private final TickSource tickSource;
    private int thingsPerTick;
    private int prescale;
    private final Listener listener;
    private AtomicInteger spent = new AtomicInteger();
    private SleepWakeup sleep = new SleepWakeup();
    private int timewiseAvailable;
    private boolean nonBlockng = false;
    private IdleNotify test__IdleNotify;

    RateHelper(TickSource tickSource, int thingsRate, int prescaler) {
        this.tickSource = tickSource;
        this.thingsPerTick = thingsRate;
        this.prescale = prescaler;
        this.timewiseAvailable = thingsRate;
        this.listener = new Listener();
        tickSource.addListener(this.listener);
    }

    public void close() {
        this.tickSource.removeListener(this.listener);
    }

    public void setThingsPerTick(int thingsPerTick) {
        this.thingsPerTick = thingsPerTick;
        this.timewiseAvailable = thingsPerTick - this.spent.get();
    }

    public int getThingsPerTick() {
        return this.thingsPerTick;
    }

    public void takeOne() {
        while (true) {
            int stored;
            if ((stored = this.spent.get()) >= this.thingsPerTick) {
                this.sleep();
                continue;
            }
            if (this.spent.compareAndSet(stored, stored + 1)) break;
        }
    }

    public int take(int n) {
        int lenToTake;
        while (true) {
            int stored = this.spent.get();
            lenToTake = Math.min(n, this.thingsPerTick - stored);
            if (stored >= this.thingsPerTick) {
                this.sleep();
                continue;
            }
            if (this.spent.compareAndSet(stored, stored + lenToTake)) break;
        }
        this.timewiseAvailable -= lenToTake;
        return lenToTake;
    }

    public void giveBack(int n) {
        this.spent.addAndGet(-n);
        this.timewiseAvailable += n;
        this.wakeup();
    }

    private void wakeup() {
        this.sleep.wakeup();
    }

    private void sleep() {
        if (this.test__IdleNotify != null && this.test__IdleNotify.idle()) {
            return;
        }
        if (this.nonBlockng) {
            throw new WouldBlockException();
        }
        this.sleep.sleep();
    }

    void test__SetIdleNotify(IdleNotify target) {
        this.test__IdleNotify = target;
    }

    public int getTimewiseAvailable() {
        return Math.max(0, this.timewiseAvailable);
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlockng = nonBlocking;
    }

    public TickSource getTickSource() {
        return this.tickSource;
    }

    public int getPrescale() {
        return this.prescale;
    }

    public void setPrescale(int prescale) {
        this.prescale = prescale;
    }

    static interface IdleNotify {
        public boolean idle();
    }

    private class Listener
    implements TickListener {
        private Listener() {
        }

        @Override
        public void tick(long tick) {
            if (RateHelper.this.prescale <= 1 || tick % (long)RateHelper.this.prescale == 0L) {
                int value;
                int stored;
                do {
                    if ((stored = RateHelper.this.spent.get()) > RateHelper.this.thingsPerTick) {
                        value = stored - RateHelper.this.thingsPerTick;
                        if (RateHelper.this.spent.compareAndSet(stored, value)) break;
                    }
                    value = 0;
                } while (!RateHelper.this.spent.compareAndSet(stored, 0));
                RateHelper.this.timewiseAvailable = RateHelper.this.thingsPerTick - value;
                RateHelper.this.wakeup();
            }
        }
    }
}

