/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.services.comm.impl;

import at.borkowski.scovillej.services.comm.Serializer;
import at.borkowski.scovillej.services.comm.impl.SimulationSocketImpl;
import at.borkowski.scovillej.services.comm.impl.SimulationSocketImplB;
import at.borkowski.spicej.streams.DelayedInputStream;
import at.borkowski.spicej.streams.RateLimitInputStream;
import at.borkowski.spicej.streams.util.PipedInputStream;
import at.borkowski.spicej.streams.util.PipedOutputStream;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;

public class SimulationSocketImplA<T>
extends SimulationSocketImpl<T> {
    RateLimitInputStream a_rate;
    RateLimitInputStream b_rate;
    DelayedInputStream a_delay;
    DelayedInputStream b_delay;

    public SimulationSocketImplA(TickSource t, Integer uplink, Integer downlink, Long updelay, Long downdelay, SimulationSocketImplB<T> clientSide, Serializer<T> serializer, int bufferSize) throws IOException {
        PipedInputStream uplink_in = new PipedInputStream(bufferSize);
        PipedOutputStream uplink_out = new PipedOutputStream(uplink_in);
        PipedInputStream downlink_in = new PipedInputStream(bufferSize);
        PipedOutputStream downlink_out = new PipedOutputStream(downlink_in);
        uplink_in.setExceptionOnDeadlock(true);
        downlink_in.setExceptionOnDeadlock(true);
        this.a_rate = SimulationSocketImplA.rate(t, uplink, uplink_in);
        this.a_delay = SimulationSocketImplA.delay(t, updelay, this.a_rate, bufferSize);
        this.setIO(t, this.a_delay, downlink_out, clientSide, serializer);
        this.b_rate = SimulationSocketImplA.rate(t, downlink, downlink_in);
        this.b_delay = SimulationSocketImplA.delay(t, downdelay, this.b_rate, bufferSize);
        clientSide.setIO(t, this.b_delay, uplink_out, this, serializer);
    }

    private static DelayedInputStream delay(TickSource t, Long delay, InputStream in, int bufferSize) {
        if (delay == null) {
            delay = 0L;
        }
        DelayedInputStream is = new DelayedInputStream(t, in, delay, bufferSize);
        is.setNonBlocking(true);
        return is;
    }

    private static RateLimitInputStream rate(TickSource t, Integer rate, InputStream in) {
        if (rate == null) {
            rate = Integer.MAX_VALUE;
        }
        RateLimitInputStream is = new RateLimitInputStream(in, t, rate, 1);
        is.setNonBlocking(true);
        return is;
    }

    public void setRates(Integer uplink, Integer downlink) {
        if (uplink == null) {
            uplink = Integer.MAX_VALUE;
        }
        if (downlink == null) {
            downlink = Integer.MAX_VALUE;
        }
        this.a_rate.setByteRate(uplink);
        this.b_rate.setByteRate(downlink);
    }
}

