/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.services.comm.impl;

import at.borkowski.scovillej.services.comm.Serializer;
import at.borkowski.scovillej.services.comm.SimulationServerSocket;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.services.comm.impl.CommunicationServiceImpl;
import at.borkowski.scovillej.services.comm.impl.SimulationSocketImplA;
import at.borkowski.scovillej.services.comm.impl.SimulationSocketImplB;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SimulationServerSocketImpl<T>
implements SimulationServerSocket<T> {
    private final CommunicationServiceImpl owner;
    private final String name;
    private final Queue<SimulationSocketImplB<T>> waitingClientSides = new LinkedList<SimulationSocketImplB<T>>();
    private final Integer uplink;
    private final Integer downlink;
    private final Long updelay;
    private final Long downdelay;
    private final Serializer<T> serializer;
    private final List<SimulationSocketImplA<T>> children = new LinkedList<SimulationSocketImplA<T>>();
    private boolean open = true;

    public SimulationServerSocketImpl(CommunicationServiceImpl owner, String name, Integer uplink, Integer downlink, Long updelay, Long downdelay, Serializer<T> serializer) {
        this.owner = owner;
        this.name = name;
        this.uplink = uplink;
        this.downlink = downlink;
        this.updelay = updelay;
        this.downdelay = downdelay;
        this.serializer = serializer;
    }

    void addWaiting(SimulationSocketImplB<T> clientSide) {
        if (!this.open) {
            throw new IllegalStateException("server socket closed");
        }
        this.waitingClientSides.add(clientSide);
    }

    @Override
    public int available() {
        return this.waitingClientSides.size();
    }

    @Override
    public SimulationSocket<T> accept() throws IOException {
        SimulationSocketImplB<T> clientSide = this.waitingClientSides.poll();
        if (clientSide == null) {
            return null;
        }
        SimulationSocketImplA<T> child = new SimulationSocketImplA<T>(this.owner.getTickSource(), this.uplink, this.downlink, this.updelay, this.downdelay, clientSide, this.serializer, this.owner.getBufferSize());
        this.children.add(child);
        return child;
    }

    @Override
    public void close() {
        this.open = false;
        this.owner.removeServerSocket(this.name);
    }

    public void setRates(Integer uplink, Integer downlink) {
        for (SimulationSocketImplA<T> child : this.children) {
            child.setRates(uplink, downlink);
        }
    }
}

