/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.services.comm.impl;

import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.Serializer;
import at.borkowski.scovillej.services.comm.SimulationServerSocket;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.services.comm.impl.SimulationServerSocketImpl;
import at.borkowski.scovillej.services.comm.impl.SimulationSocketImplB;
import at.borkowski.scovillej.services.comm.impl.serializers.BuiltInSerializers;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import at.borkowski.spicej.impl.SimulationTickSource;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommunicationServiceImpl
implements CommunicationService,
ServiceProvider<CommunicationService> {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final String phase;
    private final SimulationTickSource t = new SimulationTickSource();
    private final Map<String, SimulationServerSocketImpl<?>> serverSockets = new HashMap();
    private final Map<String, Class<?>> clazzes = new HashMap();
    private final Map<String, Integer> uplink;
    private final Map<String, Integer> downlink;
    private final Map<String, Long> updelay;
    private final Map<String, Long> downdelay;
    private final Map<Class<?>, Serializer<?>> serializers = new HashMap();
    private final int bufferSize;

    public CommunicationServiceImpl() {
        this("tick", new HashMap<String, Integer>(), new HashMap<String, Integer>(), new HashMap<String, Long>(), new HashMap<String, Long>(), 0x100000, new LinkedList());
    }

    public CommunicationServiceImpl(String phase, Map<String, Integer> uplink, Map<String, Integer> downlink, Map<String, Long> updelay, Map<String, Long> downdelay, int bufferSize, List<Serializer<?>> serializers) {
        this.phase = phase;
        this.uplink = uplink;
        this.downlink = downlink;
        this.updelay = updelay;
        this.downdelay = downdelay;
        this.bufferSize = bufferSize;
        BuiltInSerializers.addTo(this.serializers);
        for (Serializer<?> serializer : serializers) {
            this.serializers.put(serializer.getSerializedClass(), serializer);
        }
    }

    @Override
    public void initialize(Simulation simulation, SimulationInitializationContext context) {
    }

    @Override
    public <T> SimulationSocket<T> beginConnect(String name, Class<T> clazz) throws IOException {
        SimulationServerSocketImpl<?> serverSocket = this.serverSockets.get(name);
        if (!this.serverSockets.containsKey(name)) {
            throw new IOException("name \"" + name + "\" not an open server socket");
        }
        if (!this.clazzes.get(name).equals(clazz)) {
            throw new IOException("name \"" + name + "\" is of an uncompatible type (" + this.clazzes.get(name) + " != " + clazz + ")");
        }
        SimulationSocketImplB socket = new SimulationSocketImplB();
        serverSocket.addWaiting(socket);
        return socket;
    }

    @Override
    public <T> SimulationServerSocket<T> createServerSocket(String name, Class<T> clazz) throws IOException {
        if (this.serverSockets.containsKey(name)) {
            throw new IOException("name \"" + name + "\" already in use");
        }
        SimulationServerSocketImpl<T> serverSocket = new SimulationServerSocketImpl<T>(this, name, this.uplink.get(name), this.downlink.get(name), this.updelay.get(name), this.downdelay.get(name), this.getSerializer(clazz));
        this.serverSockets.put(name, serverSocket);
        this.clazzes.put(name, clazz);
        return serverSocket;
    }

    void removeServerSocket(String name) {
        this.serverSockets.remove(name);
    }

    @Override
    public void setRates(String name, Integer uplink, Integer downlink) {
        this.uplink.put(name, uplink);
        this.downlink.put(name, downlink);
        if (this.serverSockets.containsKey(name)) {
            this.serverSockets.get(name).setRates(uplink, downlink);
        }
    }

    @Override
    public <T> void addSerializer(Class<T> clazz, Serializer<T> serializer) {
        this.serializers.put(clazz, serializer);
    }

    private <T> Serializer<T> getSerializer(Class<T> clazz) {
        if (this.serializers.containsKey(clazz)) {
            return this.serializers.get(clazz);
        }
        for (Serializer<?> serializer : this.serializers.values()) {
            if (!serializer.getSerializedClass().isAssignableFrom(clazz)) continue;
            return serializer;
        }
        throw new IllegalArgumentException("serializer for " + clazz + " unknown");
    }

    @Override
    public Collection<PhaseHandler> getPhaseHandlers() {
        return Arrays.asList(new PhaseHandler(){

            @Override
            public Collection<String> getPhaseSubcription() {
                return Arrays.asList(CommunicationServiceImpl.this.phase);
            }

            @Override
            public void executePhase(SimulationContext context) {
                CommunicationServiceImpl.this.t.advance();
            }
        });
    }

    @Override
    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    @Override
    public CommunicationService getService() {
        return this;
    }

    @Override
    public Class<CommunicationService> getServiceClass() {
        return CommunicationService.class;
    }

    public TickSource getTickSource() {
        return this.t;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public Integer getDownlinkRate(String name) {
        return this.downlink.get(name);
    }

    @Override
    public Integer getUplinkRate(String name) {
        return this.uplink.get(name);
    }
}

