/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.profiling;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.profiling.PrefetchProfilingResults;
import at.borkowski.prefetchsimulation.profiling.PrefetchProfilingService;
import at.borkowski.scovillej.profile.Series;
import at.borkowski.scovillej.profile.SeriesResult;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrefetchProfilingServiceImpl
implements PrefetchProfilingService,
PrefetchProfilingResults,
ServiceProvider<PrefetchProfilingService> {
    private static String RESPONSE_TIME = "prefetch-profiling-response-time";
    private static String DATA_AGE = "prefetch-profiling-data-age";
    private static String DATA_VOLUME = "prefetch-profiling-data-volume";
    private static String HIT = "prefetch-profiling-cache-hit";
    private Simulation simulation;
    private Series<Long> seriesResponseTime;
    private Series<Long> seriesDataAge;
    private Series<Long> seriesDataVolume;
    private Series<Void> seriesHits;
    private Set<Request> cacheHitRequests = new HashSet<Request>();
    private Map<Request, Long> scheduleStart = new HashMap<Request, Long>();
    private Map<Request, Long> fetchStart = new HashMap<Request, Long>();
    private Map<Request, Long> fetchFinish = new HashMap<Request, Long>();

    @Override
    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.simulation = simulation;
        this.seriesResponseTime = context.getSeries(RESPONSE_TIME, Long.class);
        this.seriesDataAge = context.getSeries(DATA_AGE, Long.class);
        this.seriesDataVolume = context.getSeries(DATA_VOLUME, Long.class);
        this.seriesHits = context.getSeries(HIT, Void.class);
    }

    @Override
    public Collection<PhaseHandler> getPhaseHandlers() {
        return null;
    }

    @Override
    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    @Override
    public PrefetchProfilingService getService() {
        return this;
    }

    @Override
    public Class<PrefetchProfilingService> getServiceClass() {
        return PrefetchProfilingService.class;
    }

    @Override
    public void cacheHit(Request request) {
        this.cacheHitRequests.add(request);
        this.seriesHits.measure(null);
    }

    @Override
    public void scheduled(Request request, Long scheduledTime) {
        this.scheduleStart.put(request, scheduledTime);
    }

    @Override
    public void request(Request request) {
        this.fetchStart.put(request, this.simulation.getCurrentTick());
    }

    @Override
    public void response(Request request) {
        this.fetchFinish.put(request, this.simulation.getCurrentTick());
    }

    @Override
    public void arrival(Request request, long responseTime, long dataAge, int dataVolume) {
        this.seriesResponseTime.measure(responseTime);
        this.seriesDataAge.measure(dataAge);
        this.seriesDataVolume.measure(Long.valueOf(dataVolume));
    }

    @Override
    public SeriesResult<Long> getResponseTime() {
        return this.simulation.getSeries(RESPONSE_TIME, Long.class);
    }

    @Override
    public SeriesResult<Long> getDataAge() {
        return this.simulation.getSeries(DATA_AGE, Long.class);
    }

    @Override
    public SeriesResult<Long> getDataVolume() {
        return this.simulation.getSeries(DATA_VOLUME, Long.class);
    }

    @Override
    public SeriesResult<Void> getCacheHits() {
        return this.simulation.getSeries(HIT, Void.class);
    }

    @Override
    public Set<Request> getCacheHitRequests() {
        return this.cacheHitRequests;
    }

    @Override
    public Long getFetchFinish(Request request) {
        return this.fetchFinish.get(request);
    }

    @Override
    public Long getFetchStart(Request request) {
        return this.fetchStart.get(request);
    }

    @Override
    public Long getScheduledStart(Request request) {
        return this.scheduleStart.get(request);
    }
}

