/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.client;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.internal.VirtualPayload;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.io.IOException;

public class SocketProcessor {
    private final String socketName;
    private CommunicationService comm;
    private SimulationSocket<VirtualPayload> socket;
    private boolean initialized = false;

    public SocketProcessor(String socketName) {
        this.socketName = socketName;
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.comm = context.getService(CommunicationService.class);
    }

    public void executePhase(SimulationContext context) throws IOException {
        if (!this.initialized) {
            this.initialize(context);
        }
    }

    private void initialize(SimulationContext context) throws IOException {
        this.socket = this.comm.beginConnect(this.socketName, VirtualPayload.class);
        this.initialized = true;
    }

    public VirtualPayload readIfPossible() throws IOException {
        if (this.socket.available() != 0) {
            return this.socket.read();
        }
        return null;
    }

    public void request(Request request) throws IOException {
        this.socket.write(new VirtualPayload(request.getData(), false));
    }

    public boolean isReady() {
        return this.socket != null && this.socket.established();
    }
}

