/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.client;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.members.client.CacheProcessor;
import at.borkowski.prefetchsimulation.members.client.ClientCodeProcessor;
import at.borkowski.prefetchsimulation.members.client.FetchProcessor;
import at.borkowski.prefetchsimulation.members.client.SocketProcessor;
import at.borkowski.prefetchsimulation.profiling.PrefetchProfilingService;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Arrays;
import java.util.Collection;

public class FetchClient
implements SimulationMember,
PhaseHandler {
    private final SocketProcessor socketProcessor;
    private final ClientCodeProcessor clientCodeProcessor;
    private final CacheProcessor cacheProcessor;
    private final FetchProcessor fetchProcessor;
    private PrefetchProfilingService profiling;

    FetchClient(SocketProcessor socketProcessor, ClientCodeProcessor clientCodeProcessor, CacheProcessor cacheProcessor, FetchProcessor fetchProcessor) {
        this.socketProcessor = socketProcessor;
        this.clientCodeProcessor = clientCodeProcessor;
        this.cacheProcessor = cacheProcessor;
        this.fetchProcessor = fetchProcessor;
    }

    public FetchClient(String socketName) {
        this.socketProcessor = new SocketProcessor(socketName);
        this.clientCodeProcessor = new ClientCodeProcessor(this);
        this.cacheProcessor = new CacheProcessor();
        this.fetchProcessor = new FetchProcessor(this);
    }

    @Override
    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.socketProcessor.initialize(simulation, context);
        this.fetchProcessor.initialize(simulation, context);
        this.profiling = context.getService(PrefetchProfilingService.class);
    }

    @Override
    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    @Override
    public Collection<PhaseHandler> getPhaseHandlers() {
        return Arrays.asList(this);
    }

    @Override
    public void executePhase(SimulationContext context) {
        try {
            this.socketProcessor.executePhase(context);
            if (!this.socketProcessor.isReady()) {
                return;
            }
            this.clientCodeProcessor.executePhase(context);
            this.fetchProcessor.executePhase(context);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Collection<String> getPhaseSubcription() {
        return null;
    }

    public void addRequests(Collection<Request> requests) {
        this.clientCodeProcessor.addRequests(requests);
        this.fetchProcessor.addRequests(requests);
    }

    public PrefetchProfilingService getProfilingService() {
        return this.profiling;
    }

    public CacheProcessor getCacheProcessor() {
        return this.cacheProcessor;
    }

    public SocketProcessor getSocketProcessor() {
        return this.socketProcessor;
    }

    public FetchProcessor getFetchProcessor() {
        return this.fetchProcessor;
    }
}

