/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.aux;

import at.borkowski.prefetchsimulation.members.aux.RateControlService;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RateSetter
implements ServiceProvider<RateControlService>,
RateControlService {
    private CommunicationService communicationService;
    private final String socketName;
    private List<SimulationEvent> events = new LinkedList<SimulationEvent>();
    private Integer requestSpecific;
    private Integer global;

    public RateSetter(final String phase, String socketName, Map<Long, Integer> limits) {
        this.socketName = socketName;
        for (final Long tick : limits.keySet()) {
            final Integer limit = limits.get(tick);
            this.events.add(new SimulationEvent(){

                @Override
                public Collection<String> getPhaseSubcription() {
                    return Arrays.asList(phase);
                }

                @Override
                public void executePhase(SimulationContext context) {
                    RateSetter.this.global = limit;
                    RateSetter.this.refreshRates();
                }

                @Override
                public long getScheduledTick() {
                    return tick;
                }
            });
        }
    }

    @Override
    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.communicationService = context.getService(CommunicationService.class);
    }

    @Override
    public Collection<SimulationEvent> generateEvents() {
        return this.events;
    }

    @Override
    public Collection<PhaseHandler> getPhaseHandlers() {
        return null;
    }

    @Override
    public void setRequestSpecificRate(Integer requestSpecific) {
        this.requestSpecific = requestSpecific;
        this.refreshRates();
    }

    private void refreshRates() {
        Integer uplink;
        Integer downlink = uplink = this.global;
        if (this.requestSpecific != null && (this.global == null || this.global > this.requestSpecific)) {
            downlink = this.requestSpecific;
        }
        this.communicationService.setRates(this.socketName, uplink, downlink);
    }

    @Override
    public Class<RateControlService> getServiceClass() {
        return RateControlService.class;
    }

    @Override
    public RateControlService getService() {
        return this;
    }
}

