/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.internal;

import at.borkowski.prefetchsimulation.internal.VirtualPayload;
import at.borkowski.scovillej.services.comm.Serializer;
import java.nio.ByteBuffer;

public class VirtualPayloadSerializer
implements Serializer<VirtualPayload> {
    @Override
    public VirtualPayload deserialize(byte[] bytes) {
        if (bytes.length < 4) {
            throw new IllegalArgumentException("frame must be at least four bytes long");
        }
        ByteBuffer wrapper = ByteBuffer.wrap(bytes);
        return new VirtualPayload(wrapper.getInt(0));
    }

    @Override
    public Class<VirtualPayload> getSerializedClass() {
        return VirtualPayload.class;
    }

    @Override
    public byte[] serialize(VirtualPayload object) {
        byte[] ret = new byte[4 + Math.max(0, object.getTransferPayload() ? object.getSize() - 4 : 0)];
        ByteBuffer wrapper = ByteBuffer.allocate(4);
        wrapper.putInt(0, object.getSize());
        wrapper.get(ret, 0, 4);
        return ret;
    }
}

