/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class UniformIntegerDistribution
implements Distribution<Integer> {
    private final int min;
    private final int max;
    private final int span;

    public UniformIntegerDistribution(int min, int max) {
        this.min = min;
        this.max = max;
        this.span = max - min;
    }

    @Override
    public Integer getValue(RandomSource randomSource) {
        if (this.span == 0) {
            return this.min;
        }
        long r = (randomSource.nextLong() % (long)this.span + (long)this.span) % (long)this.span;
        return (int)((long)this.min + r);
    }

    @Override
    public Integer getMean() {
        return this.min + (this.max - this.min) / 2;
    }
}

