/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.algorithms.PrefetchAlgorithm;
import at.borkowski.prefetchsimulation.genesis.Genesis;
import at.borkowski.prefetchsimulation.internal.VirtualPayloadSerializer;
import at.borkowski.prefetchsimulation.members.aux.RatePredictionServiceProvider;
import at.borkowski.prefetchsimulation.members.aux.RateSetter;
import at.borkowski.prefetchsimulation.members.client.FetchClient;
import at.borkowski.prefetchsimulation.members.server.FetchServer;
import at.borkowski.prefetchsimulation.profiling.PrefetchProfilingResults;
import at.borkowski.prefetchsimulation.profiling.PrefetchProfilingServiceImpl;
import at.borkowski.scovillej.SimulationBuilder;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.CommunicationServiceBuilder;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PrefetchSimulationBuilder {
    private static final String RATE_PHASE = "rate";
    private static final String COMM_PHASE = "comm";
    private static final String SOCKET_NAME = "fetch";
    private static final long BASE_DELAY = 2L;
    private final FetchClient fetchClient;
    private final PrefetchProfilingServiceImpl profilingService;
    private final ServiceProvider<CommunicationService> communicationService;
    private Map<Long, Integer> limitsReal = null;
    private Map<Long, Integer> limitsPredicted = null;
    private Map<String, String> algorithmConfiguration = new HashMap<String, String>();
    private SimulationBuilder builder = new SimulationBuilder();
    private RateSetter rateSetter;
    private RatePredictionServiceProvider ratePredictionServiceProvider;
    private Simulation simulation = null;

    public PrefetchSimulationBuilder() {
        this.builder.phase(RATE_PHASE);
        this.builder.phase("tick");
        this.builder.phase(COMM_PHASE);
        CommunicationServiceBuilder commBuilder = new CommunicationServiceBuilder().communicationPhase(COMM_PHASE).delay(SOCKET_NAME, 2L).serializer(new VirtualPayloadSerializer());
        this.communicationService = commBuilder.create();
        this.builder.service(this.communicationService);
        this.profilingService = new PrefetchProfilingServiceImpl();
        this.builder.service(this.profilingService);
        this.builder.member(new FetchServer(SOCKET_NAME));
        this.fetchClient = new FetchClient(SOCKET_NAME);
        this.builder.member(this.fetchClient);
    }

    public static PrefetchSimulationBuilder fromGenesis(Genesis genesis) {
        return PrefetchSimulationBuilder.fromGenesis(genesis, PrefetchSimulationBuilder.getAlgorithm(genesis));
    }

    private static PrefetchAlgorithm getAlgorithm(Genesis genesis) {
        try {
            PrefetchAlgorithm algorithm = genesis.getAlgorithm().newInstance();
            return algorithm;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static PrefetchSimulationBuilder fromGenesis(Genesis genesis, PrefetchAlgorithm algorithm) {
        PrefetchSimulationBuilder builder = new PrefetchSimulationBuilder();
        builder.totalTicks(genesis.getTicks());
        builder.requests(genesis.getRequests());
        builder.limitsReal(genesis.getRateReal());
        builder.limitsPredicted(genesis.getRatePredicted());
        builder.algorithm(algorithm);
        builder.algorithmConfiguration(genesis.getAlgorithmConfiguration());
        builder.lookAheadTime(genesis.getLookAheadTime());
        return builder;
    }

    public Simulation create() {
        if (this.simulation != null) {
            throw new IllegalStateException();
        }
        this.rateSetter = new RateSetter(RATE_PHASE, SOCKET_NAME, this.limitsReal);
        this.builder.service(this.rateSetter);
        this.ratePredictionServiceProvider = new RatePredictionServiceProvider(this.limitsPredicted);
        this.builder.service(this.ratePredictionServiceProvider);
        this.simulation = this.builder.create();
        return this.simulation;
    }

    public PrefetchSimulationBuilder limitReal(Integer byteRate) {
        this.communicationService.getService().setRates(SOCKET_NAME, byteRate, byteRate);
        return this;
    }

    public PrefetchSimulationBuilder limitsReal(Map<Long, Integer> byteRates) {
        this.limitsReal = byteRates;
        return this;
    }

    public PrefetchSimulationBuilder limitsPredicted(Map<Long, Integer> byteRates) {
        this.limitsPredicted = byteRates;
        return this;
    }

    public PrefetchSimulationBuilder request(Request request) {
        this.fetchClient.addRequests(Arrays.asList(request));
        return this;
    }

    public PrefetchSimulationBuilder requests(Collection<Request> requests) {
        this.fetchClient.addRequests(requests);
        return this;
    }

    public PrefetchSimulationBuilder totalTicks(long tickCount) {
        this.builder.totalTicks(tickCount);
        return this;
    }

    public PrefetchSimulationBuilder algorithm(PrefetchAlgorithm algorithm) {
        algorithm.configure(this.algorithmConfiguration);
        this.fetchClient.getFetchProcessor().setAlgorithm(algorithm);
        return this;
    }

    public void algorithmConfiguration(Map<String, String> algorithmConfiguration) {
        this.algorithmConfiguration = algorithmConfiguration;
        this.fetchClient.getFetchProcessor().getAlgorithm().configure(this.algorithmConfiguration);
    }

    public PrefetchSimulationBuilder lookAheadTime(long lookAheadTime) {
        this.fetchClient.getFetchProcessor().setLookAheadTime(lookAheadTime);
        return this;
    }

    public PrefetchProfilingResults getProfiling() {
        return this.profilingService;
    }

    FetchClient test__getFetchClient() {
        return this.fetchClient;
    }

    ServiceProvider<CommunicationService> test__getCommunicationService() {
        return this.communicationService;
    }

    String test__getSocketName() {
        return SOCKET_NAME;
    }

    RateSetter test__getRateSetter() {
        return this.rateSetter;
    }

    RatePredictionServiceProvider test__getRatePredictionServiceProvider() {
        return this.ratePredictionServiceProvider;
    }

    static PrefetchSimulationBuilder __test_fromGenesisMockAlgorithm(Genesis genesis, Mocker<PrefetchAlgorithm> mocker) {
        return PrefetchSimulationBuilder.fromGenesis(genesis, mocker.mock(PrefetchSimulationBuilder.getAlgorithm(genesis)));
    }

    public static interface Mocker<T> {
        public T mock(T var1);
    }
}

