/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.services.comm;

import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.Serializer;
import at.borkowski.scovillej.services.comm.impl.CommunicationServiceImpl;
import at.borkowski.scovillej.simulation.ServiceProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommunicationServiceBuilder {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private String phase = "tick";
    private int bufferSize = 0x100000;
    private final Map<String, Integer> uplink = new HashMap<String, Integer>();
    private final Map<String, Integer> downlink = new HashMap<String, Integer>();
    private final Map<String, Long> updelay = new HashMap<String, Long>();
    private final Map<String, Long> downdelay = new HashMap<String, Long>();
    private final List<Serializer<?>> serializers = new LinkedList();
    private ServiceProvider<CommunicationService> instance;

    public CommunicationServiceBuilder communicationPhase(String phase) {
        this.checkUncreated();
        this.phase = phase;
        return this;
    }

    public CommunicationServiceBuilder limit(String socketName, Integer uplinkRate, Integer downlinkRate) {
        this.checkUncreated();
        this.uplink.put(socketName, uplinkRate);
        this.downlink.put(socketName, downlinkRate);
        return this;
    }

    public CommunicationServiceBuilder limit(String socketName, Integer rate) {
        return this.limit(socketName, rate, rate);
    }

    public CommunicationServiceBuilder delay(String socketName, Long updelay, Long downdelay) {
        this.checkUncreated();
        this.updelay.put(socketName, updelay);
        this.downdelay.put(socketName, downdelay);
        return this;
    }

    public CommunicationServiceBuilder delay(String socketName, Long delay) {
        return this.delay(socketName, delay, delay);
    }

    public CommunicationServiceBuilder bufferSize(int bufferSize) {
        this.checkUncreated();
        this.bufferSize = bufferSize;
        return this;
    }

    public CommunicationServiceBuilder serializer(Serializer<?> serializer) {
        this.checkUncreated();
        this.serializers.add(serializer);
        return this;
    }

    private void checkUncreated() {
        if (this.instance != null) {
            throw new IllegalStateException("instance already created");
        }
    }

    private void createIfNecessary() {
        if (this.instance != null) {
            return;
        }
        this.instance = new CommunicationServiceImpl(this.phase, this.uplink, this.downlink, this.updelay, this.downdelay, this.bufferSize, this.serializers);
    }

    public ServiceProvider<CommunicationService> create() {
        this.createIfNecessary();
        return this.instance;
    }
}

