/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.server;

import at.borkowski.prefetchsimulation.members.server.ClientProcessor;
import at.borkowski.prefetchsimulation.members.server.SocketProcessor;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FetchServer
implements SimulationMember,
PhaseHandler {
    private final SocketProcessor socketProcessor;
    private final List<ClientProcessor> clientProcessors = new LinkedList<ClientProcessor>();

    FetchServer(SocketProcessor socketProcessor) {
        this.socketProcessor = socketProcessor;
    }

    public FetchServer(String socketName) {
        this.socketProcessor = new SocketProcessor(this, socketName);
    }

    @Override
    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.socketProcessor.initialize(simulation, context);
    }

    @Override
    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    @Override
    public Collection<PhaseHandler> getPhaseHandlers() {
        return Arrays.asList(this);
    }

    @Override
    public void executePhase(SimulationContext context) {
        try {
            this.socketProcessor.executePhase(context);
            if (this.clientProcessors.size() > 0) {
                this.clientProcessors.get((int)(context.getCurrentTick() % (long)this.clientProcessors.size())).handle(context);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Collection<String> getPhaseSubcription() {
        return null;
    }

    public void deregisterClientProcessor(ClientProcessor clientHandler) {
        this.clientProcessors.remove(clientHandler);
    }

    public void registerClientProcessor(ClientProcessor clientProcessor) {
        this.clientProcessors.add(clientProcessor);
    }
}

