/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.client;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.members.client.FetchClient;
import at.borkowski.scovillej.simulation.SimulationContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClientCodeProcessor {
    private final FetchClient owner;
    private Set<Request> required = new HashSet<Request>();
    private Set<Request> missed = new HashSet<Request>();

    public ClientCodeProcessor(FetchClient owner) {
        this.owner = owner;
    }

    public void executePhase(SimulationContext context) {
        long tick = context.getCurrentTick();
        HashSet<Request> done = new HashSet<Request>();
        for (Request request : this.required) {
            if (request.getDeadline() > tick) continue;
            if (this.owner.getCacheProcessor().hasFile(request)) {
                if (request.getDeadline() == tick) {
                    this.owner.getProfilingService().cacheHit(request);
                }
                this.owner.getProfilingService().arrival(request, tick - request.getDeadline(), tick - this.owner.getCacheProcessor().getRequestTimestamp(request), request.getData());
                done.add(request);
                continue;
            }
            if (this.missed.contains(request)) continue;
            this.owner.getFetchProcessor().urge(tick, request);
            this.missed.add(request);
        }
        this.required.removeAll(done);
    }

    public void addRequests(Collection<Request> requests) {
        this.required.addAll(requests);
    }
}

