/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.genesis;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.genesis.Genesis;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class GenesisWriter {
    private final BufferedWriter output;

    public GenesisWriter(OutputStream output) {
        try {
            this.output = new BufferedWriter(new OutputStreamWriter(output, "UTF8"));
        }
        catch (UnsupportedEncodingException ueEx) {
            throw new RuntimeException(ueEx);
        }
    }

    public void write(Genesis genesis) throws IOException {
        long tick;
        HashMap<Long, Collection<String>> lines = new HashMap<Long, Collection<String>>();
        this.add(lines, 0L, "algorithm", genesis.getAlgorithm().getName());
        for (String key : genesis.getAlgorithmConfiguration().keySet()) {
            this.add(lines, 0L, "algorithm-parameter", key, genesis.getAlgorithmConfiguration().get(key));
        }
        this.add(lines, 0L, "look-ahead", String.valueOf(genesis.getLookAheadTime()));
        this.addRates(lines, genesis.getRateReal(), "rate-real");
        this.addRates(lines, genesis.getRatePredicted(), "rate-prediction");
        this.add(lines, genesis.getTicks() - 1L, "end");
        for (Request request : genesis.getRequests()) {
            this.add(lines, request.getDeadline(), "request", String.valueOf(request.getData()), String.valueOf(request.getAvailableByterate()));
        }
        LinkedList<Long> ticks = new LinkedList<Long>();
        Iterator<Object> iterator = lines.keySet().iterator();
        while (iterator.hasNext()) {
            tick = (Long)iterator.next();
            if (ticks.contains(tick)) continue;
            ticks.add(tick);
        }
        Collections.sort(ticks);
        iterator = ticks.iterator();
        while (iterator.hasNext()) {
            tick = (Long)iterator.next();
            for (String line : (Collection)lines.get(tick)) {
                this.output.write(line);
            }
        }
        this.output.flush();
    }

    private void addRates(Map<Long, Collection<String>> lines, Map<Long, Integer> rates, String command) {
        for (long tick : rates.keySet()) {
            this.add(lines, tick, command, String.valueOf(rates.get(tick)));
        }
    }

    private void add(Map<Long, Collection<String>> lines, long tick, String ... tokens) {
        StringBuilder sb = new StringBuilder();
        sb.append(tick);
        for (String token : tokens) {
            sb.append(' ');
            sb.append(token);
        }
        sb.append('\n');
        String line = sb.toString();
        if (!lines.containsKey(tick)) {
            lines.put(tick, new LinkedList());
        }
        lines.get(tick).add(line);
    }
}

