/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.genesis;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.algorithms.PrefetchAlgorithm;
import at.borkowski.prefetchsimulation.configuration.Configuration;
import at.borkowski.prefetchsimulation.configuration.RequestSeries;
import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.genesis.Genesis;
import at.borkowski.prefetchsimulation.util.RepeatableRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class GenesisGenerator {
    private static Random seedSource = new Random();
    private final RepeatableRandom random = new RepeatableRandom(seedSource.nextLong());
    private final long totalTicks;
    private final long lookAheadTime;
    private final Distribution<Integer> absoluteJitter;
    private final Distribution<Double> relativeJitter;
    private final double networkUptime;
    private final Distribution<Double> relativePredictionTimeError;
    private final Distribution<Double> relativePredictionAmplitudeError;
    private final Distribution<Long> absolutePredictionTimeError;
    private final Distribution<Integer> absolutePredictionAmplitudeError;
    private final Distribution<Integer> byterate;
    private final Distribution<Long> slotLength;
    private final Collection<RequestSeries> recurringSeries;
    private final Collection<Request> intermittentRequests;
    private final Class<? extends PrefetchAlgorithm> algorithm;
    private final Map<String, String> algorithmConfiguration;

    public GenesisGenerator(Configuration configuration) {
        this.totalTicks = configuration.getTotalTicks();
        this.byterate = configuration.getByterate();
        this.slotLength = configuration.getSlotLength();
        this.networkUptime = configuration.getNetworkUptime();
        this.absoluteJitter = configuration.getAbsoluteJitter();
        this.relativeJitter = configuration.getRelativeJitter();
        this.relativePredictionTimeError = configuration.getRelativePredictionTimeError();
        this.relativePredictionAmplitudeError = configuration.getRelativePredictionAmplitudeError();
        this.absolutePredictionTimeError = configuration.getAbsolutePredictionTimeError();
        this.absolutePredictionAmplitudeError = configuration.getAbsolutePredictionAmplitudeError();
        this.recurringSeries = configuration.getRecurringRequestSeries();
        this.intermittentRequests = configuration.getIntermittentRequests();
        this.algorithmConfiguration = configuration.getAlgorithmConfiguration();
        this.algorithm = configuration.getAlgorithm();
        this.lookAheadTime = configuration.getLookAheadTime();
        if (configuration.hasSeed()) {
            this.random.setSeed(configuration.getSeed());
        }
    }

    public void seed(long seed) {
        this.random.setSeed(seed);
    }

    private long clamp(long min, long value, long max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private int clamp(int min, int value, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public Genesis generate() {
        RepeatableRandom randomNetworkQuality = this.random.fork();
        RepeatableRandom randomNetworkPrediction = this.random.fork();
        RepeatableRandom randomNetworkGrain = this.random.fork();
        RepeatableRandom randomSeries = this.random.fork();
        Map<Long, Integer> networkQuality = this.generateNetworkQuality(randomNetworkQuality);
        Map<Long, Integer> prediction = this.generateNetworkQualityPrediction(randomNetworkPrediction, networkQuality);
        networkQuality = this.grainNetworkQuality(randomNetworkGrain, networkQuality);
        LinkedList<Request> requests = new LinkedList<Request>();
        requests.addAll(this.intermittentRequests);
        for (RequestSeries series : this.recurringSeries) {
            this.generateSeries(randomSeries, requests, series);
        }
        Genesis genesis = new Genesis(this.totalTicks, requests, networkQuality, prediction, this.algorithm, this.algorithmConfiguration, this.lookAheadTime);
        return genesis;
    }

    private void generateSeries(RepeatableRandom random, List<Request> requests, RequestSeries series) {
        RepeatableRandom randomSize = random.fork();
        RepeatableRandom randomByterate = random.fork();
        RepeatableRandom randomInterval = random.fork();
        long start = series.getStartTick().getValue(random.fork());
        long end = series.getEndTick().getValue(random.fork());
        start = this.clamp(0L, start, this.totalTicks - 1L);
        end = this.clamp(start, end, this.totalTicks - 1L);
        for (long current = start; current <= end; current += this.clamp(1L, series.getInterval().getValue(randomInterval), Long.MAX_VALUE)) {
            int data = series.getSize().getValue(randomSize);
            int byterate = series.getByterate().getValue(randomByterate);
            data = this.clamp(1, data, Integer.MAX_VALUE);
            byterate = this.clamp(1, byterate, Integer.MAX_VALUE);
            requests.add(new Request(current, data, byterate));
        }
    }

    private Map<Long, Integer> generateNetworkQuality(RepeatableRandom random) {
        RepeatableRandom randomByterate = random.fork();
        RepeatableRandom randomUptime = random.fork();
        RepeatableRandom randomLength = random.fork();
        HashMap<Long, Integer> ret = new HashMap<Long, Integer>();
        int previousRate = -1;
        for (long tick = 0L; tick < this.totalTicks; tick += this.clamp(1L, this.slotLength.getValue(randomLength), Long.MAX_VALUE)) {
            int byterate = this.byterate.getValue(randomByterate);
            if (randomUptime.nextDouble() > this.networkUptime) {
                byterate = 0;
            }
            if (previousRate != -1 && byterate != 0) {
                byterate = (2 * byterate + 1 * previousRate) / 3;
            }
            ret.put(tick, byterate);
            if (byterate == 0) continue;
            previousRate = byterate;
        }
        return ret;
    }

    private Map<Long, Integer> grainNetworkQuality(RepeatableRandom random, Map<Long, Integer> networkQuality) {
        RepeatableRandom randomRelative = random.fork();
        RepeatableRandom randomAbsolute = random.fork();
        HashMap<Long, Integer> ret = new HashMap<Long, Integer>();
        int lastRate = -1;
        long tickStep = Math.max(1L, this.slotLength.getMean() / 10L);
        for (long tick = 0L; tick < this.totalTicks; ++tick) {
            if (networkQuality.containsKey(tick)) {
                lastRate = networkQuality.get(tick);
            }
            double relativeJitter = this.relativeJitter.getValue(randomRelative);
            int absoluteJitter = this.absoluteJitter.getValue(randomAbsolute);
            if (tick % tickStep != 0L) continue;
            int byterate = lastRate;
            if (byterate != 0) {
                byterate = (int)((1.0 + relativeJitter) * (double)byterate + (double)absoluteJitter);
            }
            ret.put(tick, this.clamp(0, byterate, Integer.MAX_VALUE));
        }
        return ret;
    }

    private Map<Long, Integer> generateNetworkQualityPrediction(RepeatableRandom random, Map<Long, Integer> networkQuality) {
        RepeatableRandom randomTick = random.fork();
        RepeatableRandom randomAmplitude = random.fork();
        HashMap<Long, Integer> ret = new HashMap<Long, Integer>();
        for (long tick : networkQuality.keySet()) {
            long predictionTick = 0L;
            if (tick != 0L) {
                double relativeTimeError = this.relativePredictionTimeError.getValue(randomTick);
                long absoluteTimeError = this.absolutePredictionTimeError.getValue(randomTick);
                predictionTick = tick + absoluteTimeError + (long)(relativeTimeError * (double)this.slotLength.getMean().longValue());
            }
            predictionTick = this.clamp(0L, predictionTick, this.totalTicks - 1L);
            double relativeAmplitudeError = this.relativePredictionAmplitudeError.getValue(randomAmplitude);
            int absoluteAmplitudeError = this.absolutePredictionAmplitudeError.getValue(randomAmplitude);
            int predictionByterate = networkQuality.get(tick);
            predictionByterate = (int)((double)predictionByterate * (1.0 + relativeAmplitudeError)) + absoluteAmplitudeError;
            ret.put(predictionTick, predictionByterate);
        }
        return ret;
    }
}

