/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class NormalDoubleDistribution
implements Distribution<Double> {
    private final double mean;
    private final double sd;

    public NormalDoubleDistribution(double mean, double sd) {
        this.mean = mean;
        this.sd = sd;
    }

    @Override
    public Double getValue(RandomSource randomSource) {
        if (this.sd == 0.0) {
            return this.mean;
        }
        return randomSource.nextGaussian() * this.sd + this.mean;
    }

    @Override
    public Double getMean() {
        return this.mean;
    }
}

