/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.algorithms;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.algorithms.PrefetchAlgorithm;
import at.borkowski.prefetchsimulation.members.aux.RatePredictionService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RespectRatePredictionAlgorithm
implements PrefetchAlgorithm {
    public static final long CONNECTION_OVERHEAD = 5L;
    private double alpha = 1.0;

    @Override
    public void configure(Map<String, String> configuration) {
        if (configuration.containsKey("alpha")) {
            this.alpha = Double.parseDouble(configuration.get("alpha"));
        }
    }

    @Override
    public Map<Request, Long> schedule(Collection<Request> requests, RatePredictionService ratePredictionService) {
        HashMap<Request, Long> ret = new HashMap<Request, Long>();
        LinkedList<Request> sortedByDeadline = new LinkedList<Request>(requests);
        Collections.sort(sortedByDeadline, new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getDeadline() > o2.getDeadline() ? -1 : 1;
            }
        });
        long previousStart = Long.MAX_VALUE;
        for (Request req : sortedByDeadline) {
            long start = this.getStart(previousStart, req, ratePredictionService);
            ret.put(req, start);
            previousStart = start;
        }
        return ret;
    }

    private long getStart(long busyUntil, Request req, RatePredictionService ratePredictionService) {
        long tick;
        Integer prediction;
        long data = req.getData();
        for (tick = Math.min(busyUntil, req.getDeadline()) - 5L - 1L; data > 0L && tick >= 0L; data -= (long)Math.min(req.getAvailableByterate(), prediction), --tick) {
            prediction = ratePredictionService.predict(tick);
            prediction = prediction == null ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf((int)(prediction.doubleValue() * this.alpha));
        }
        return tick;
    }
}

