/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.pack;

import at.bestsolution.maven.osgi.pack.Product;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

@Mojo(name="package-product", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ProductPackagePlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true)
    private Product product;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Xpp3Dom xppProduct = new Xpp3Dom("product");
        xppProduct.setAttribute("name", this.product.name);
        xppProduct.setAttribute("uid", this.product.uid);
        xppProduct.setAttribute("id", this.product.id);
        xppProduct.setAttribute("application", this.product.application);
        xppProduct.setAttribute("version", this.product.version);
        xppProduct.setAttribute("useFeatures", this.product.useFeatures + "");
        xppProduct.setAttribute("includeLaunchers", this.product.includeLaunchers + "");
        Xpp3Dom configIni = new Xpp3Dom("configIni");
        configIni.setAttribute("use", "default");
        xppProduct.addChild(configIni);
        Xpp3Dom launcherArgs = new Xpp3Dom("launcherArgs");
        Xpp3Dom programArgs = new Xpp3Dom("programArgs");
        for (String string : this.product.launcherArgs.programArguments) {
            programArgs.setValue(string);
        }
        launcherArgs.addChild(programArgs);
        Xpp3Dom vmArgs = new Xpp3Dom("vmArgs");
        for (Map.Entry<Object, Object> entry : this.product.launcherArgs.vmProperties.entrySet()) {
            vmArgs.setValue("-D" + entry.getKey() + "=" + entry.getValue());
        }
        launcherArgs.addChild(vmArgs);
        xppProduct.addChild(launcherArgs);
        xppProduct.addChild(new Xpp3Dom("windowImages"));
        Xpp3Dom xpp3Dom = new Xpp3Dom("features");
        this.project.getArtifacts().stream().filter(this::featureFilter).map(a -> {
            Xpp3Dom feature = new Xpp3Dom("feature");
            feature.setAttribute("id", a.getArtifactId());
            return feature;
        }).forEach(arg_0 -> ((Xpp3Dom)xpp3Dom).addChild(arg_0));
        xppProduct.addChild(xpp3Dom);
        Xpp3Dom xpp3Dom2 = new Xpp3Dom("configurations");
        for (Map.Entry<String, Integer> e : this.product.startLevels.entrySet()) {
            Xpp3Dom plugin = new Xpp3Dom("plugin");
            plugin.setAttribute("id", e.getKey());
            plugin.setAttribute("autoStart", "true");
            plugin.setAttribute("startLevel", e.getValue() + "");
            xpp3Dom2.addChild(plugin);
        }
        xppProduct.addChild(xpp3Dom2);
        try (PrintWriter writer = new PrintWriter(new File(this.projectDir, this.product.id + ".product"));){
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
            Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)xppProduct);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean featureFilter(Artifact a) {
        try (JarFile jf = new JarFile(a.getFile());){
            boolean bl = jf.getEntry("feature.xml") != null;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

