/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.pack;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

@Mojo(name="package-p2-repo", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class P2RepositoryPackagePlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/source")
    private File directory;
    @Parameter(defaultValue="${project.build.directory}/source-repository")
    private File repositoryLocation;
    @Parameter(defaultValue="true")
    private boolean publishArtifacts;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Component
    private P2ApplicationLauncher launcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Artifact a : this.project.getArtifacts()) {
            try {
                JarFile f = new JarFile(a.getFile());
                Throwable throwable = null;
                try {
                    this.handleJar(a, f);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (f == null) continue;
                    if (throwable != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    f.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            this.publishContent();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private void publishContent() throws MojoFailureException, MalformedURLException {
        int result;
        this.launcher.setWorkingDirectory(this.project.getBasedir());
        this.launcher.setApplicationName("org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher");
        this.launcher.addArguments(new String[]{"-artifactRepository", this.repositoryLocation.toURI().toURL().toString()});
        this.launcher.addArguments(new String[]{"-metadataRepository", this.repositoryLocation.toURI().toURL().toString()});
        this.launcher.addArguments(new String[]{"-source", this.directory.toString()});
        if (this.publishArtifacts) {
            this.launcher.addArguments(new String[]{"-publishArtifacts"});
        }
        if (this.compress) {
            this.launcher.addArguments(new String[]{"-compress"});
        }
        if ((result = this.launcher.execute(0)) != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    private void handleJar(Artifact a, JarFile jf) throws IOException {
        File dir;
        ZipEntry entry = jf.getEntry("feature.xml");
        if (entry == null) {
            if (jf.getManifest().getMainAttributes().getValue("Bundle-SymbolicName") == null) {
                return;
            }
            dir = new File(this.directory, "plugins");
        } else {
            dir = new File(this.directory, "features");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Files.copy(a.getFile().toPath(), dir.toPath().resolve(a.getFile().getName()), new CopyOption[0]);
    }
}

