/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.pack;

import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

@Mojo(name="package-feature", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class FeaturePackagePlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(required=true)
    private String providerName;
    @Parameter(required=true)
    private String qualifier;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private String license;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object n;
        Xpp3Dom d = new Xpp3Dom("feature");
        d.setAttribute("id", this.project.getArtifactId());
        d.setAttribute("label", this.project.getName());
        Version version = MavenVersion.parseString((String)this.project.getVersion()).getOSGiVersion();
        d.setAttribute("version", version.getWithoutQualifier().toString() + "." + this.qualifier);
        d.setAttribute("provider-name", this.providerName);
        if (this.description != null) {
            n = new Xpp3Dom("description");
            n.setValue(this.description);
            d.addChild((Xpp3Dom)n);
        }
        if (this.copyright != null) {
            n = new Xpp3Dom("copyright");
            n.setValue(this.copyright);
            d.addChild((Xpp3Dom)n);
        }
        if (this.license != null) {
            n = new Xpp3Dom("license");
            n.setValue(this.license);
            d.addChild((Xpp3Dom)n);
        }
        for (Object a : this.project.getDependencies()) {
            Xpp3Dom p = new Xpp3Dom("plugin");
            Optional<Artifact> first = this.project.getArtifacts().stream().filter(this.filter((Dependency)a)).findFirst();
            if (!first.isPresent()) {
                throw new IllegalStateException("Could not find artifact for '" + a.getGroupId() + ":" + a.getArtifactId() + ":" + FeaturePackagePlugin.removeQualifier(a.getVersion()) + "'");
            }
            Manifest mm = this.getManifest(first.get());
            p.setAttribute("id", FeaturePackagePlugin.bundleName(mm));
            p.setAttribute("version", FeaturePackagePlugin.bundleVersion(mm));
            p.setAttribute("unpack", FeaturePackagePlugin.dirShape(mm) + "");
            d.addChild(p);
        }
        if (!this.classesDir.exists()) {
            this.classesDir.mkdirs();
        }
        try {
            Object a;
            PrintWriter writer = new PrintWriter(new File(this.classesDir, "feature.xml"));
            a = null;
            try {
                PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
                Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)d);
            }
            catch (Throwable xmlWriter) {
                a = xmlWriter;
                throw xmlWriter;
            }
            finally {
                if (writer != null) {
                    if (a != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable xmlWriter) {
                            ((Throwable)a).addSuppressed(xmlWriter);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to write feature.xml in '" + this.classesDir.getAbsolutePath() + "'", (Exception)e);
        }
        Manifest m = new Manifest();
        File file = new File(this.classesDir, "META-INF/MANIFEST.MF");
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            m.write(out);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write META-INF/MANIFEST.MF in '" + this.classesDir.getAbsolutePath() + "'", (Exception)e);
        }
    }

    private Predicate<Artifact> filter(Dependency d) {
        String version = FeaturePackagePlugin.removeQualifier(d.getVersion());
        return a -> d.getArtifactId().equals(a.getArtifactId()) && d.getGroupId().equals(a.getGroupId()) && version.equals(FeaturePackagePlugin.removeQualifier(a.getVersion()));
    }

    private static String removeQualifier(String version) {
        int idx = version.indexOf(45);
        if (idx != -1) {
            return version.substring(0, idx);
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(Artifact a) {
        try (JarFile f = new JarFile(a.getFile());){
            Manifest manifest = f.getManifest();
            return manifest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String bundleName(Manifest m) {
        String name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        return name.split(";")[0];
    }

    private static String bundleVersion(Manifest m) {
        String name = m.getMainAttributes().getValue("Bundle-Version");
        return name.split(";")[0];
    }

    private static boolean dirShape(Manifest m) {
        return "dir".equals(m.getMainAttributes().getValue("Eclipse-BundleShape"));
    }
}

