/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.exec;

import at.bestsolution.maven.osgi.exec.MVNBaseOSGiLaunchPlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="exec-osgi-java", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MVNJavaOSGiLaunch
extends MVNBaseOSGiLaunchPlugin {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Path ini = this.generateConfigIni(this.project);
        Optional<URL> launcherJar = this.project.getArtifacts().stream().filter(a -> "org.eclipse.equinox.launcher".equals(a.getArtifactId())).findFirst().map(a -> {
            try {
                return a.getFile().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
        URLClassLoader l = new URLClassLoader(new URL[]{launcherJar.get()});
        final ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-configuration");
        cmd.add("file:" + ini.toString());
        cmd.addAll(this.programArguments);
        System.getProperties().putAll((Map<?, ?>)this.vmProperties);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Class<?> cl = this.getContextClassLoader().loadClass("org.eclipse.equinox.launcher.Main");
                    Method m = cl.getDeclaredMethod("main", String[].class);
                    m.invoke(null, new Object[]{cmd.toArray(new String[0])});
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        t.setContextClassLoader(l);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

