/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.exec;

import at.bestsolution.maven.osgi.exec.MVNBaseOSGiLaunchPlugin;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.cli.CommandLineUtils;

@Mojo(name="exec-osgi", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MVNExecOSGiLaunch
extends MVNBaseOSGiLaunchPlugin {
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="exec.workingdir")
    private File workingDirectory;
    @Parameter(property="exec.args")
    private String commandlineArgs;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    private File basedir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Path ini = this.generateConfigIni(this.project);
        Optional<File> launcherJar = this.project.getArtifacts().stream().filter(a -> "org.eclipse.equinox.launcher".equals(a.getArtifactId())).findFirst().map(a -> a.getFile());
        String argsProp = System.getProperty("exec.args");
        ArrayList<String> commandArguments = new ArrayList<String>();
        commandArguments.addAll(this.vmProperties.entrySet().stream().map(e -> "-D" + e.getKey() + "=" + e.getValue()).collect(Collectors.toList()));
        if (!Strings.isNullOrEmpty((String)argsProp)) {
            this.handleSystemPropertyArguments(argsProp, commandArguments);
        }
        commandArguments.add("-jar");
        commandArguments.add(launcherJar.get().toPath().toAbsolutePath().toString());
        commandArguments.add("-configuration");
        commandArguments.add("file:" + ini.toString());
        commandArguments.addAll(this.programArguments);
        Map<String, String> enviro = this.handleSystemEnvVariables();
        CommandLine commandLine = new CommandLine("/Library/Java/JavaVirtualMachines/jdk1.8.0_121.jdk/Contents/Home/bin/java");
        String[] args = commandArguments.toArray(new String[commandArguments.size()]);
        commandLine.addArguments(args, false);
        DefaultExecutor exec = new DefaultExecutor();
        exec.setWorkingDirectory(this.workingDirectory);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in);
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        psh.start();
        try {
            exec.execute(commandLine, enviro);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                psh.stop();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void handleSystemPropertyArguments(String argsProp, List<String> commandArguments) throws MojoExecutionException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)argsProp);
            commandArguments.addAll(Arrays.asList(args));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't parse systemproperty 'exec.args'");
        }
    }

    private Map<String, String> handleSystemEnvVariables() throws MojoExecutionException {
        HashMap<String, String> enviro = new HashMap<String, String>();
        Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
        for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
            enviro.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.environmentVariables != null) {
            enviro.putAll(this.environmentVariables);
        }
        return enviro;
    }

    private void handleWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
    }
}

