/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.osgi.exec;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class MVNBaseOSGiLaunchPlugin
extends AbstractMojo {
    private static final String LF = System.getProperty("line.separator");
    @Parameter
    protected List<String> programArguments;
    @Parameter
    protected Properties vmProperties;
    @Parameter
    protected Map<String, Integer> startLevels;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(defaultValue="${project.build.finalName}")
    private String filename;
    @Parameter
    private boolean debug;

    private String toReferenceURL(Bundle element, boolean project) throws IOException {
        StringBuilder w = new StringBuilder();
        w.append("reference\\:file\\:" + element.path.toString());
        if (element.startLevel != null) {
            w.append("@" + element.startLevel + "\\:start");
        } else {
            w.append("@start");
        }
        return w.toString();
    }

    protected Path generateConfigIni(MavenProject project) {
        Path p;
        block18: {
            Set<Bundle> bundles = project.getArtifacts().stream().map(this::map).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            if (project.getPackaging().equals("jar")) {
                Path binary = project.getArtifact().getFile().toPath();
                bundles.add(new Bundle(this.getManifest(binary).get(), binary));
            }
            p = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(project.getArtifactId()).resolve("configuration");
            Optional<Bundle> simpleConfigurator = bundles.stream().filter(b -> "org.eclipse.equinox.simpleconfigurator".equals(b.symbolicName)).findFirst();
            Optional<Bundle> equinox = bundles.stream().filter(b -> "org.eclipse.osgi".equals(b.symbolicName)).findFirst();
            try {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (simpleConfigurator.isPresent()) {
                Path configIni = p.resolve("config.ini");
                try (BufferedWriter writer = Files.newBufferedWriter(configIni, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    Path bundlesInfo = this.generateBundlesInfo(p, bundles);
                    writer.append("osgi.bundles=" + this.toReferenceURL(simpleConfigurator.get(), false));
                    writer.append(LF);
                    writer.append("osgi.bundles.defaultStartLevel=4");
                    writer.append(LF);
                    writer.append("osgi.install.area=file\\:" + p.getParent().resolve("install").toString());
                    writer.append(LF);
                    writer.append("osgi.framework=file\\:" + equinox.get().path.toString());
                    writer.append(LF);
                    writer.append("eclipse.p2.data.area=@config.dir/.p2");
                    writer.append(LF);
                    writer.append("org.eclipse.equinox.simpleconfigurator.configUrl=file\\:" + bundlesInfo.toAbsolutePath().toString());
                    writer.append(LF);
                    writer.append("osgi.configuration.cascaded=false");
                    writer.append(LF);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Only 'org.eclipse.equinox.simpleconfigurator' is supported");
        }
        return p;
    }

    private Path generateBundlesInfo(Path configurationDir, Set<Bundle> bundles) {
        Path bundleInfo = configurationDir.resolve("org.eclipse.equinox.simpleconfigurator").resolve("bundles.info");
        try {
            Files.createDirectories(bundleInfo.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(bundleInfo, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.append("#encoding=UTF-8");
            writer.append(LF);
            writer.append("#version=1");
            writer.append(LF);
            for (Bundle b : bundles) {
                if ("org.eclipse.osgi".equals(b.symbolicName)) continue;
                writer.append(b.symbolicName);
                writer.append("," + b.version);
                writer.append(",file:" + this.generateLocalPath(b, configurationDir.resolve(".explode")).toString());
                writer.append("," + b.startLevel);
                writer.append("," + b.autoStart);
                writer.append(LF);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bundleInfo;
    }

    private Path generateLocalPath(Bundle b, Path explodeDir) {
        if (b.dirShape && Files.isRegularFile(b.path, new LinkOption[0])) {
            Path p = explodeDir.resolve(b.symbolicName + "_" + b.version);
            if (!Files.exists(p, new LinkOption[0])) {
                try (ZipFile z = new ZipFile(b.path.toFile());){
                    z.stream().forEach(e -> {
                        Path ep = explodeDir.resolve(e.getName());
                        if (e.isDirectory()) {
                            try {
                                Files.createDirectories(ep, new FileAttribute[0]);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            try (OutputStream out = Files.newOutputStream(ep, new OpenOption[0]);
                                 InputStream in = z.getInputStream((ZipEntry)e);){
                                int l;
                                byte[] buf = new byte[1024];
                                while ((l = in.read(buf)) != -1) {
                                    out.write(buf, 0, l);
                                }
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            return p;
        }
        return b.path.toAbsolutePath();
    }

    private Optional<Bundle> map(Artifact a) {
        return this.getManifest(a.getFile().toPath()).filter(MVNBaseOSGiLaunchPlugin::isBundle).map((? super T m) -> new Bundle((Manifest)m, a.getFile().toPath()));
    }

    private static String bundleName(Manifest m) {
        String name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        return name.split(";")[0];
    }

    private static boolean isBundle(Manifest m) {
        return m.getMainAttributes().getValue("Bundle-SymbolicName") != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Manifest> getManifest(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            Path mf = p.resolve("META-INF").resolve("MANIFEST.MF");
            if (!Files.exists(mf, new LinkOption[0])) {
                return Optional.empty();
            }
            try (InputStream in = Files.newInputStream(mf, new OpenOption[0]);){
                Optional<Manifest> optional = Optional.of(new Manifest(in));
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (JarFile f = new JarFile(p.toFile());){
            Optional<Manifest> optional = Optional.of(f.getManifest());
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Integer getStartLevel(Manifest m) {
        String name = MVNBaseOSGiLaunchPlugin.bundleName(m);
        if (this.startLevels != null) {
            return this.startLevels.get(name);
        }
        switch (name) {
            case "org.eclipse.core.runtime": {
                return 4;
            }
            case "org.eclipse.equinox.common": {
                return 2;
            }
            case "org.eclipse.equinox.ds": {
                return 2;
            }
            case "org.eclipse.equinox.event": {
                return 2;
            }
            case "org.eclipse.equinox.simpleconfigurator": {
                return 1;
            }
            case "org.eclipse.osgi": {
                return -1;
            }
        }
        return null;
    }

    public class Bundle {
        public final String symbolicName;
        public final String version;
        public final Integer startLevel;
        public final Path path;
        public final boolean dirShape;
        public final boolean autoStart;

        public Bundle(Manifest m, Path path) {
            this(MVNBaseOSGiLaunchPlugin.bundleName(m), m.getMainAttributes().getValue("Bundle-Version"), this$0.getStartLevel(m), path, this$0.getStartLevel(m) != null, "dir".equals(m.getMainAttributes().getValue("Eclipse-BundleShape")));
        }

        public Bundle(String symbolicName, String version, Integer startLevel, Path path, boolean autoStart, boolean dirShape) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.startLevel = startLevel == null ? 4 : startLevel;
            this.path = path;
            this.autoStart = autoStart;
            this.dirShape = dirShape;
        }
    }
}

