/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.fx.test.junit;

import at.bestsolution.fx.test.junit.FXTestRule;
import at.bestsolution.fx.test.rcontrol.RController;
import at.bestsolution.fx.test.rcontrol.RControllerFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.fx.core.ServiceUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class FXComponentTest<N extends Parent, O> {
    @Rule
    public FXTestRule r = new FXTestRule();
    private final Class<N> root;
    private O component;
    private Stage stage;
    private static RControllerFactory FACTORY = (RControllerFactory)ServiceUtils.getService(RControllerFactory.class).get();
    private RController controller;

    public FXComponentTest(Class<N> root) {
        this.root = root;
    }

    protected Stage createStage() {
        return new Stage();
    }

    protected Scene createScene(N parent) {
        return new Scene(parent, 800.0, 600.0);
    }

    protected abstract O createComponent(N var1);

    public O component() {
        return this.component;
    }

    @Before
    public void init() {
        this.stage = this.createStage();
        try {
            Parent instance = (Parent)this.root.newInstance();
            this.component = this.createComponent(instance);
            Scene scene = this.createScene(instance);
            this.stage.setScene(scene);
            this.stage.show();
            this.controller = FACTORY.create(scene);
            this.controller.waitForRender();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public final RController rcontroller() {
        return this.controller;
    }

    @After
    public void cleanup() {
        this.stage.close();
    }
}

