/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dialog;

import com.sun.javafx.tk.Toolkit;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import org.eclipse.fx.ui.controls.dialog.Dialog;
import org.eclipse.fx.ui.controls.dialog.DialogMessagesProvider;
import org.eclipse.fx.ui.controls.stage.FrameEvent;
import org.eclipse.fx.ui.panes.GridLayoutPane;
import org.eclipse.jdt.annotation.NonNull;

public class MessageDialog
extends Dialog {
    int index = 0;
    Function<MessageDialogButton, Boolean> buttonHandler;

    MessageDialog(@NonNull Function<@NonNull MessageDialogButton, @NonNull Boolean> buttonHandler, @NonNull String windowTitle, @NonNull String message, @NonNull Type type, String ... dialogButtonLabels) {
        super(MessageDialog.createDialogArea(type, message), windowTitle);
        this.buttonHandler = buttonHandler;
        this.getDialogPane().getButtonList().addAll((Collection)Stream.of(dialogButtonLabels).map(d -> new MessageDialogButton(this.index++, (String)d)).collect(Collectors.toList()));
    }

    private static Node createDialogArea(@NonNull Type type, String message) {
        GridLayoutPane b = new GridLayoutPane();
        b.setHorizontalSpacing(20);
        b.setNumColumns(2);
        b.getStyleClass().add((Object)("efx-messagedialog-" + type.name().toLowerCase()));
        ImageView view = new ImageView();
        view.getStyleClass().add((Object)"efx-messagedialog-icon");
        b.getChildren().add((Object)view);
        Label l = new Label(message);
        l.getStyleClass().add((Object)"efx-messagedialog-message");
        b.getChildren().add((Object)l);
        return b;
    }

    @Override
    protected void handleButtonPress(Dialog.DialogButton button) {
        if (this.buttonHandler.apply((MessageDialogButton)button).booleanValue()) {
            this.close();
        }
    }

    public static void openBlockingErrorDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        ErrorDialog d = new ErrorDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
    }

    private static void openBlocking(MessageDialog d) {
        String id = UUID.randomUUID().toString();
        d.addEventHandler(FrameEvent.CLOSED, e -> Toolkit.getToolkit().exitNestedEventLoop((Object)id, null));
        Toolkit.getToolkit().enterNestedEventLoop((Object)id);
    }

    public static void openWarningDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        WarningDialog d = new WarningDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
    }

    public static void openInformationDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        InformationDialog d = new InformationDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
    }

    public static @NonNull QuestionResult openQuestionDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        return MessageDialog.openQuestionDialog(title, message, QuestionResult.YES, scenegraphAttacher);
    }

    public static @NonNull QuestionResult openQuestionDialog(@NonNull String title, @NonNull String message, @NonNull QuestionResult defaultValue, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        QuestionDialog d = new QuestionDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
        return d.getResult();
    }

    public static QuestionCancelResult openQuestionCancelDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        return MessageDialog.openQuestionCancelDialog(title, message, QuestionCancelResult.YES, scenegraphAttacher);
    }

    public static QuestionCancelResult openQuestionCancelDialog(@NonNull String title, @NonNull String message, @NonNull QuestionCancelResult defaultValue, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        QuestionCancelDialog d = new QuestionCancelDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
        return d.getResult();
    }

    public static ConfirmResult openConfirmDialog(@NonNull String title, @NonNull String message, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        return MessageDialog.openConfirmDialog(title, message, ConfirmResult.OK, scenegraphAttacher);
    }

    public static ConfirmResult openConfirmDialog(@NonNull String title, @NonNull String message, @NonNull ConfirmResult defaultValue, @NonNull Consumer<@NonNull MessageDialog> scenegraphAttacher) {
        ConfirmDialog d = new ConfirmDialog(title, message);
        scenegraphAttacher.accept(d);
        MessageDialog.openBlocking(d);
        return d.getResult();
    }

    public static class ConfirmDialog
    extends MessageDialog {
        private ConfirmResult result = ConfirmResult.CANCEL;

        ConfirmDialog(@NonNull String windowTitle, @NonNull String message) {
            super(b -> Boolean.FALSE, windowTitle, message, Type.CONFIRM, DialogMessagesProvider.createDefaultRegistry(windowTitle).ok(), DialogMessagesProvider.createDefaultRegistry(windowTitle).cancel());
            this.buttonHandler = b -> {
                this.result = b.index == 0 ? ConfirmResult.OK : ConfirmResult.CANCEL;
                return Boolean.TRUE;
            };
        }

        public ConfirmResult getResult() {
            return this.result;
        }
    }

    public static enum ConfirmResult {
        OK(0),
        CANCEL(1);

        private final int index;

        private ConfirmResult(int index) {
            this.index = index;
        }

        static ConfirmResult fromIndex(int index) {
            if (index == ConfirmResult.OK.index) {
                return OK;
            }
            return CANCEL;
        }
    }

    public static class ErrorDialog
    extends OkDialog {
        public ErrorDialog(@NonNull String title, @NonNull String message) {
            super(title, message, Type.ERROR);
        }
    }

    public static class InformationDialog
    extends OkDialog {
        public InformationDialog(@NonNull String title, @NonNull String message) {
            super(title, message, Type.WARNING);
        }
    }

    static class MessageDialogButton
    extends Dialog.DialogButton {
        final int index;

        public MessageDialogButton(int index, @NonNull String label) {
            super(label);
            this.index = index;
        }
    }

    static class OkDialog
    extends MessageDialog {
        public OkDialog(@NonNull String title, @NonNull String message, Type type) {
            super(b -> Boolean.TRUE, title, message, Type.ERROR, DialogMessagesProvider.createDefaultRegistry(title).ok());
        }
    }

    public static class QuestionCancelDialog
    extends MessageDialog {
        private QuestionCancelResult result = QuestionCancelResult.CANCEL;

        public QuestionCancelDialog(@NonNull String windowTitle, @NonNull String message) {
            super(e -> Boolean.FALSE, windowTitle, message, Type.QUESTION, DialogMessagesProvider.createDefaultRegistry(windowTitle).yes(), DialogMessagesProvider.createDefaultRegistry(windowTitle).no(), DialogMessagesProvider.createDefaultRegistry(windowTitle).cancel());
            this.buttonHandler = b -> {
                this.result = b.index == 0 ? QuestionCancelResult.YES : (b.index == 1 ? QuestionCancelResult.NO : QuestionCancelResult.CANCEL);
                return Boolean.TRUE;
            };
        }

        public QuestionCancelResult getResult() {
            return this.result;
        }
    }

    public static enum QuestionCancelResult {
        YES(0),
        NO(1),
        CANCEL(2);

        private final int index;

        private QuestionCancelResult(int index) {
            this.index = index;
        }

        static QuestionCancelResult fromIndex(int index) {
            if (index == QuestionCancelResult.YES.index) {
                return YES;
            }
            if (index == QuestionCancelResult.NO.index) {
                return NO;
            }
            return CANCEL;
        }
    }

    public static class QuestionDialog
    extends MessageDialog {
        private @NonNull QuestionResult result = QuestionResult.NO;

        public QuestionDialog(@NonNull String windowTitle, @NonNull String message) {
            super(b -> Boolean.FALSE, windowTitle, message, Type.QUESTION, DialogMessagesProvider.createDefaultRegistry(windowTitle).yes(), DialogMessagesProvider.createDefaultRegistry(windowTitle).no());
            this.buttonHandler = b -> {
                this.result = b.index == 0 ? QuestionResult.YES : QuestionResult.NO;
                return Boolean.TRUE;
            };
        }

        public @NonNull QuestionResult getResult() {
            return this.result;
        }
    }

    public static enum QuestionResult {
        YES(0),
        NO(1);

        private final int index;

        private QuestionResult(int index) {
            this.index = index;
        }

        static @NonNull QuestionResult fromIndex(int index) {
            if (index == QuestionResult.YES.index) {
                return YES;
            }
            return NO;
        }
    }

    public static enum Type {
        CUSTOM,
        QUESTION,
        INFORMATION,
        WARNING,
        ERROR,
        CONFIRM,
        QUESTION_CANCEL;

    }

    public static class WarningDialog
    extends OkDialog {
        public WarningDialog(@NonNull String title, @NonNull String message) {
            super(title, message, Type.WARNING);
        }
    }
}

