/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.bindex;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.osgi.service.indexer.impl.RepoIndex;

@Mojo(name="bindex")
public class BIndexMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File repoDir;
    @Parameter(required=true)
    private File indexFile;
    @Parameter(defaultValue="true")
    private boolean compressed;
    @Parameter(defaultValue="false")
    private boolean pretty;
    @Parameter(defaultValue="")
    private String licenseUrl;
    @Parameter(defaultValue="Unnamed")
    private String repositoryName;
    @Parameter(required=true)
    private String rootUrl;
    @Parameter
    private String urlTemplate;

    private Map<String, String> buildConfiguration() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("compressed", String.valueOf(this.compressed));
        configuration.put("pretty", String.valueOf(this.pretty));
        configuration.put("license.url", this.licenseUrl);
        configuration.put("repository.name", this.repositoryName);
        configuration.put("root.url", this.rootUrl);
        configuration.put("url.template", this.urlTemplate);
        return configuration;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Hello, world.");
        this.getLog().info((CharSequence)("repoDir" + this.repoDir));
        this.getLog().info((CharSequence)("indexFile " + this.indexFile));
        RepoIndex repoIndex = new RepoIndex();
        final HashSet files = new HashSet();
        try {
            Files.walkFileTree(Paths.get(this.repoDir.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    BIndexMojo.this.getLog().debug((CharSequence)("Checking " + file));
                    if (file.getFileName().toString().endsWith(".jar")) {
                        BIndexMojo.this.getLog().debug((CharSequence)("Adding " + file));
                        files.add(file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("damn it", (Exception)e);
        }
        Path indexFilePath = Paths.get(this.indexFile.toURI());
        if (!Files.exists(indexFilePath, new LinkOption[0])) {
            try {
                Files.createFile(indexFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("damn it", (Exception)e);
            }
        }
        try (OutputStream out = Files.newOutputStream(indexFilePath, new OpenOption[0]);){
            repoIndex.index(files, out, this.buildConfiguration());
        }
        catch (IOException e) {
            throw new MojoExecutionException("damn it", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("damn it", e);
        }
    }
}

