/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.Bundle;
import at.bestsolution.maven.publisher.ExportPackage;
import at.bestsolution.maven.publisher.Feature;
import at.bestsolution.maven.publisher.Fragment;
import at.bestsolution.maven.publisher.ImportPackage;
import at.bestsolution.maven.publisher.OsgiToMaven;
import at.bestsolution.maven.publisher.RequireBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2ToMavenSax
extends OsgiToMaven {
    private String indexZip;

    public P2ToMavenSax(String indexZip, String repositoryUrl, String repositoryId) {
        super(repositoryUrl, repositoryId);
        this.indexZip = indexZip;
    }

    @Override
    public List<Bundle> generateBundleList() throws Throwable {
        P2ToMavenSax.unzipRepository(new File(this.indexZip), this.workingDirectory);
        P2ToMavenSax.unzipRepository(new File(this.workingDirectory, "content.jar"), this.workingDirectory);
        FileUtils.copyDirectory((File)new File(this.workingDirectory, "plugins"), (File)this.workingDirectory);
        SAXParserFactory instance = SAXParserFactory.newInstance();
        SAXParser parser = instance.newSAXParser();
        SaxHandlerImpl dh = new SaxHandlerImpl();
        parser.parse((InputStream)new FileInputStream(new File(this.workingDirectory, "content.xml")), (DefaultHandler)dh);
        return dh.bundles;
    }

    @Override
    public List<Feature> generateFeatureList() throws Throwable {
        P2ToMavenSax.unzipRepository(new File(this.indexZip), this.workingDirectory);
        P2ToMavenSax.unzipRepository(new File(this.workingDirectory, "content.jar"), this.workingDirectory);
        FileUtils.copyDirectory((File)new File(this.workingDirectory, "features"), (File)this.workingDirectory);
        SAXParserFactory instance = SAXParserFactory.newInstance();
        SAXParser parser = instance.newSAXParser();
        FeatureSaxHandlerImpl dh = new FeatureSaxHandlerImpl();
        parser.parse((InputStream)new FileInputStream(new File(this.workingDirectory, "content.xml")), (DefaultHandler)dh);
        return dh.features;
    }

    static class SaxHandlerImpl
    extends DefaultHandler {
        private Bundle currentBundle;
        private List<Bundle> bundles = new ArrayList<Bundle>();
        private boolean inUnit;
        private boolean inProvides;
        private boolean inRequires;

        SaxHandlerImpl() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("unit")) {
                this.inUnit = true;
                this.currentBundle = new Bundle();
                this.currentBundle.setBundleId(attributes.getValue("id"));
                this.currentBundle.setVersion(attributes.getValue("version"));
            } else if (this.inUnit && qName.equals("provides")) {
                this.inProvides = true;
            } else if (this.inUnit && qName.equals("requires")) {
                this.inRequires = true;
            } else if (this.inProvides && qName.equals("provided")) {
                if (attributes.getValue("namespace").equals("java.package")) {
                    ExportPackage p = new ExportPackage();
                    p.setName(attributes.getValue("name"));
                    p.setVersion(attributes.getValue("version"));
                    this.currentBundle.addExport(p);
                } else if (attributes.getValue("namespace").equals("osgi.fragment")) {
                    Fragment f = new Fragment();
                    f.setBundleId(this.currentBundle.getBundleId());
                    f.setVersion(this.currentBundle.getVersion());
                    this.currentBundle.getExportPackages().forEach(f::addExport);
                    this.currentBundle.getImportPackages().forEach(f::addImport);
                    this.currentBundle.getRequiredBundles().forEach(f::addRequire);
                    this.currentBundle = f;
                }
            } else if (this.inRequires && qName.equals("required")) {
                if (attributes.getValue("namespace").equals("java.package")) {
                    ImportPackage ip = new ImportPackage();
                    ip.setName(attributes.getValue("name"));
                    ip.setOptional("true".equals(attributes.getValue("optional")));
                    this.currentBundle.addImport(ip);
                } else if (attributes.getValue("namespace").equals("osgi.bundle")) {
                    RequireBundle rb = new RequireBundle();
                    rb.setName(attributes.getValue("name"));
                    rb.setOptional("true".equals(attributes.getValue("optional")));
                    this.currentBundle.addRequire(rb);
                }
            } else if (this.currentBundle != null && qName.equals("property")) {
                if ("df_LT.bundleVendor".equals(attributes.getValue("name")) || "df_LT.Bundle-Vendor".equals(attributes.getValue("name")) || "df_LT.providerName".equals(attributes.getValue("name"))) {
                    this.currentBundle.setVendor(attributes.getValue("value"));
                } else if ("df_LT.bundleName".equals(attributes.getValue("name")) || "df_LT.Bundle-Name".equals(attributes.getValue("name")) || "df_LT.pluginName".equals(attributes.getValue("name"))) {
                    this.currentBundle.setName(attributes.getValue("value"));
                }
            }
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("unit")) {
                if (this.currentBundle != null) {
                    this.bundles.add(this.currentBundle);
                }
                this.currentBundle = null;
                this.inUnit = false;
            } else if (qName.equals("provides")) {
                this.inProvides = false;
            } else if (qName.equals("requires")) {
                this.inRequires = false;
            }
            super.endElement(uri, localName, qName);
        }
    }

    static class FeatureSaxHandlerImpl
    extends DefaultHandler {
        private Feature currentFeature;
        private List<Feature> features = new ArrayList<Feature>();
        private boolean inRequires;

        FeatureSaxHandlerImpl() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("unit") && attributes.getValue("id").endsWith("feature.group")) {
                this.currentFeature = new Feature();
                String value = attributes.getValue("id");
                this.currentFeature.setFeatureId(value.substring(0, value.length() - "feature.group".length() - 1));
                this.currentFeature.setVersion(attributes.getValue("version"));
                this.features.add(this.currentFeature);
            } else if (this.currentFeature != null && qName.equals("property")) {
                if ("org.eclipse.equinox.p2.provider".equals(attributes.getValue("name"))) {
                    this.currentFeature.setVendor(attributes.getValue("value"));
                } else if ("org.eclipse.equinox.p2.name".equals(attributes.getValue("name"))) {
                    this.currentFeature.setName(attributes.getValue("value"));
                }
            } else if (this.currentFeature != null && qName.equals("requires")) {
                this.inRequires = true;
            } else if (this.inRequires && qName.equals("required")) {
                String value = attributes.getValue("name");
                if (value.endsWith("feature.jar")) {
                    return;
                }
                if (value.endsWith("feature.group")) {
                    Feature f = new Feature();
                    f.setFeatureId(value.substring(0, value.length() - "feature.group".length() - 1));
                    this.currentFeature.getFeatures().add(f);
                } else {
                    RequireBundle requireBundle = new RequireBundle();
                    requireBundle.setName(value);
                    this.currentFeature.getBundles().add(requireBundle);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("unit")) {
                this.currentFeature = null;
            } else if (qName.equals("requires")) {
                this.inRequires = false;
            }
        }
    }
}

