/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.RequireBundle;
import at.bestsolution.maven.publisher.ResolvedBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class Feature {
    private String featureId;
    private String name;
    private String vendor;
    private String version;
    private List<RequireBundle> bundles = new ArrayList<RequireBundle>();
    private List<ResolvedBundle> resolvedBundleDeps;
    private List<Feature> features = new ArrayList<Feature>();
    private List<Feature> resolvedFeatures;

    public List<RequireBundle> getBundles() {
        return this.bundles;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<ResolvedBundle> getResolvedBundleDeps() {
        return this.resolvedBundleDeps;
    }

    public List<Feature> getResolvedFeatures() {
        return this.resolvedFeatures;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Feature [featureId=" + this.featureId + ", name=" + this.name + ", vendor=" + this.vendor + ", version=" + this.version + "]";
    }

    public void resolveBundles(Function<Feature, Set<ResolvedBundle>> resolver) {
        if (this.resolvedBundleDeps == null) {
            this.resolvedBundleDeps = new ArrayList<ResolvedBundle>((Collection)resolver.apply(this));
            Collections.sort(this.resolvedBundleDeps, new Comparator<ResolvedBundle>(){

                @Override
                public int compare(ResolvedBundle o1, ResolvedBundle o2) {
                    return o1.getBundle().getBundleId().compareTo(o2.getBundle().getBundleId());
                }
            });
        }
    }

    public void resolveFeatures(Function<Feature, Set<Feature>> resolver) {
        if (this.resolvedFeatures == null) {
            this.resolvedFeatures = new ArrayList<Feature>((Collection)resolver.apply(this));
            Collections.sort(this.resolvedFeatures, new Comparator<Feature>(){

                @Override
                public int compare(Feature o1, Feature o2) {
                    return o1.getFeatureId().compareTo(o2.getFeatureId());
                }
            });
        }
    }
}

