/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.Bundle;
import at.bestsolution.maven.publisher.ExportPackage;
import at.bestsolution.maven.publisher.Fragment;
import at.bestsolution.maven.publisher.ImportPackage;
import at.bestsolution.maven.publisher.OsgiToMaven;
import at.bestsolution.maven.publisher.RequireBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class R5ToMavenSax
extends OsgiToMaven {
    static boolean DEBUG = false;
    private String indexZip;

    public R5ToMavenSax(String indexZip, String repositoryUrl, String repositoryId) {
        super(repositoryUrl, repositoryId);
        this.indexZip = indexZip;
    }

    @Override
    public List<Bundle> generateBundleList() throws Throwable {
        R5ToMavenSax.unzipRepository(new File(this.indexZip), this.workingDirectory);
        SAXParserFactory instance = SAXParserFactory.newInstance();
        SAXParser parser = instance.newSAXParser();
        SaxHandlerImpl dh = new SaxHandlerImpl();
        parser.parse((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(new File(this.workingDirectory, "repository.xml.gz"))), (DefaultHandler)dh);
        return dh.bundles;
    }

    static class SaxHandlerImpl
    extends DefaultHandler {
        private List<Bundle> bundles = new ArrayList<Bundle>();
        private Bundle currentBundle;
        private ExportPackage currentExport;
        private ImportPackage currentImport;
        private RequireBundle currentRequireBundle;
        private boolean inResource;
        private Context context;
        private String name;

        SaxHandlerImpl() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (DEBUG) {
                System.err.println("IN: " + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    System.err.println(" - " + attributes.getQName(i) + " = " + attributes.getValue(i));
                }
            }
            if (qName.equals("resource")) {
                this.inResource = true;
            } else if (this.inResource && qName.equals("capability")) {
                if ("osgi.identity".equals(attributes.getValue("namespace"))) {
                    this.context = Context.OSGI_IDENTITY;
                } else if ("osgi.wiring.package".equals(attributes.getValue("namespace"))) {
                    this.context = Context.OSGI_EXPORT_PACKAGE;
                    this.currentExport = new ExportPackage();
                    if (this.currentBundle != null) {
                        this.currentBundle.addExport(this.currentExport);
                    }
                }
            } else if (this.inResource && qName.equals("requirement")) {
                if ("osgi.wiring.package".equals(attributes.getValue("namespace"))) {
                    this.context = Context.OSGI_IMPORT_PACKAGE;
                    this.currentImport = new ImportPackage();
                    if (this.currentBundle != null) {
                        this.currentBundle.addImport(this.currentImport);
                    }
                } else if ("osgi.wiring.bundle".equals(attributes.getValue("namespace"))) {
                    this.context = Context.OSGI_REQUIRE_BUNDLE;
                    this.currentRequireBundle = new RequireBundle();
                    if (this.currentBundle != null) {
                        this.currentBundle.addRequire(this.currentRequireBundle);
                    }
                }
            } else if (this.context == Context.OSGI_IDENTITY && qName.equals("attribute")) {
                if ("type".equals(attributes.getValue("name"))) {
                    if ("osgi.bundle".equals(attributes.getValue("value"))) {
                        this.currentBundle = new Bundle();
                        this.currentBundle.setBundleId(this.name);
                    } else if ("osgi.fragment".equals(attributes.getValue("value"))) {
                        this.currentBundle = new Fragment();
                        this.currentBundle.setBundleId(this.name);
                    }
                } else if ("osgi.identity".equals(attributes.getValue("name"))) {
                    this.name = attributes.getValue("value");
                } else if ("version".equals(attributes.getValue("name"))) {
                    this.currentBundle.setVersion(attributes.getValue("value"));
                }
            } else if (this.context == Context.OSGI_EXPORT_PACKAGE && qName.equals("attribute")) {
                if ("osgi.wiring.package".equals(attributes.getValue("name"))) {
                    this.currentExport.setName(attributes.getValue("value"));
                } else if ("version".equals(attributes.getValue("name"))) {
                    this.currentExport.setVersion(attributes.getValue("value"));
                }
            } else if (this.context == Context.OSGI_IMPORT_PACKAGE && qName.equals("directive")) {
                if ("filter".equals(attributes.getValue("name"))) {
                    String filter = attributes.getValue("value");
                    this.currentImport.setName(filter.substring(filter.indexOf("osgi.wiring.package=") + "osgi.wiring.package=".length(), filter.indexOf(41)));
                } else if ("resolution".equals(attributes.getValue("name"))) {
                    this.currentImport.setOptional("optional".equals(attributes.getValue("value")));
                }
            } else if (this.context == Context.OSGI_REQUIRE_BUNDLE && qName.equals("directive")) {
                if ("filter".equals(attributes.getValue("name"))) {
                    String filter = attributes.getValue("value");
                    this.currentRequireBundle.setName(filter.substring(filter.indexOf("osgi.wiring.bundle=") + "osgi.wiring.bundle=".length(), filter.indexOf(41)));
                } else if ("resolution".equals(attributes.getValue("name"))) {
                    this.currentRequireBundle.setOptional("optional".equals(attributes.getValue("value")));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (DEBUG) {
                System.err.println("OUT: " + qName);
            }
            if (this.inResource && qName.equals("resource")) {
                this.inResource = false;
                if (this.currentBundle != null) {
                    this.bundles.add(this.currentBundle);
                }
                this.currentBundle = null;
                this.context = null;
            } else if (qName.equals("capability") || qName.equals("requirement")) {
                this.context = null;
            }
        }
    }

    static enum Context {
        OSGI_IDENTITY,
        OSGI_EXPORT_PACKAGE,
        OSGI_IMPORT_PACKAGE,
        OSGI_REQUIRE_BUNDLE;

    }
}

