/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.Bundle;
import at.bestsolution.maven.publisher.ResolvedBundle;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class OsgiToMaven {
    protected final File workingDirectory = Files.createTempDir();
    private Map<String, Set<Bundle>> bundleExports;
    private Map<String, List<Bundle>> bundleById;
    private Function<Bundle, Optional<MavenDep>> mavenReplacementLookup = b -> Optional.empty();
    private Predicate<Bundle> publishFilter = b -> true;
    private Predicate<Bundle> bundleFilter = b -> true;
    private Predicate<Bundle> snapshotFilter = b -> false;
    private Predicate<Bundle> sourceEnforced = b -> true;
    private Function<Bundle, String> projectUrlResolver = b -> "https://projects.eclipse.org/";
    private Function<Bundle, String> groupIdResolver = b -> "osgi.to.maven";
    private Function<Bundle, SCM> scmUrlResolver = b -> new SCM("http://git.eclipse.org/c/", null, null);
    private Function<Bundle, List<Developer>> developerResolver = b -> {
        if (b.getBundleId().startsWith("org.eclipse")) {
            return Collections.singletonList(new Developer("https://projects.eclipse.org/", null, null));
        }
        return Collections.emptyList();
    };
    private Function<Bundle, List<License>> licenseResolver = b -> {
        if (b.getBundleId().startsWith("org.eclipse")) {
            return Collections.singletonList(new License("Eclipse Public License 1.0", "http://www.eclipse.org/legal/epl-v10.html"));
        }
        if (b.getBundleId().startsWith("org.apache")) {
            return Collections.singletonList(new License("Apache License, Version 2.0", "https://www.apache.org/licenses/LICENSE-2.0.txt"));
        }
        return Collections.emptyList();
    };
    private BiPredicate<Bundle, ResolvedBundle> resolvedBundleFilter = (b, rb) -> true;
    private final String repositoryId;
    private final String repositoryUrl;
    private boolean dryRun = false;
    private static final int PUBLISHING_THREADS = 1;
    private Indexer indexer;
    private IndexingContext indexContext;
    private static AtomicInteger counter = new AtomicInteger();

    public void setMavenReplacementLookup(Function<Bundle, Optional<MavenDep>> mavenReplacementLookup) {
        this.mavenReplacementLookup = mavenReplacementLookup;
    }

    public void setPublishFilter(Predicate<Bundle> publishFilter) {
        this.publishFilter = publishFilter;
    }

    public void setBundleFilter(Predicate<Bundle> bundleFilter) {
        this.bundleFilter = bundleFilter;
    }

    public void setProjectUrlResolver(Function<Bundle, String> projectUrlResolver) {
        this.projectUrlResolver = projectUrlResolver;
    }

    public void setSourceEnforced(Predicate<Bundle> sourceEnforced) {
        this.sourceEnforced = sourceEnforced;
    }

    public void setGroupIdResolver(Function<Bundle, String> groupIdResolver) {
        this.groupIdResolver = groupIdResolver;
    }

    public void setSnapshotFilter(Predicate<Bundle> snapshotFilter) {
        this.snapshotFilter = snapshotFilter;
    }

    public void setResolvedBundleFilter(BiPredicate<Bundle, ResolvedBundle> resolvedBundleFilter) {
        this.resolvedBundleFilter = resolvedBundleFilter;
    }

    public OsgiToMaven(String repositoryUrl, String repositoryId) {
        this.repositoryUrl = repositoryUrl;
        this.repositoryId = repositoryId;
    }

    public static void unzipRepository(File archive, File outDir) throws ZipException, IOException {
        ZipFile zipfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            OsgiToMaven.unzipEntry(zipfile, entry, outDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            OsgiToMaven.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            OsgiToMaven.createDir(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDir(File dir) {
        dir.mkdirs();
    }

    private Set<ResolvedBundle> resolve(Bundle b) {
        HashSet rv = new HashSet();
        rv.addAll(b.getImportPackages().stream().filter(i -> !i.isOptional()).map(i -> {
            Set<Bundle> set = this.bundleExports.get(i.getName());
            if (set == null) {
                set = new HashSet<Bundle>();
                if (!(i.isOptional() || i.getName().startsWith("javax") || i.getName().equals("org.ietf.jgss"))) {
                    System.err.println("Could not resolve package '" + i.getName() + "' for '" + b.getBundleId() + "' ");
                }
            }
            return set.stream().map(bb -> new ResolvedBundle((Bundle)bb, false)).collect(Collectors.toSet());
        }).flatMap(bs -> bs.stream()).collect(Collectors.toSet()));
        rv.addAll(b.getRequiredBundles().stream().filter(i -> !i.isOptional()).map(i -> {
            List<Bundle> list = this.bundleById.get(i.getName());
            if (list == null) {
                list = new ArrayList<Bundle>();
                if (!(i.isOptional() || i.getName().equals("system.bundle") || i.getName().startsWith("javax"))) {
                    System.err.println("Could not resolve bundle '" + i.getName() + "' for '" + b.getBundleId() + "' ");
                }
            }
            return list.stream().map(bb -> new ResolvedBundle((Bundle)bb, false)).collect(Collectors.toSet());
        }).flatMap(bs -> bs.stream()).collect(Collectors.toSet()));
        rv.addAll(b.getImportPackages().stream().filter(i -> i.isOptional()).map(i -> {
            Set<Bundle> set = this.bundleExports.get(i.getName());
            if (set == null) {
                set = new HashSet<Bundle>();
                if (!(i.isOptional() || i.getName().startsWith("javax") || i.getName().equals("org.ietf.jgss"))) {
                    System.err.println("Could not resolve package '" + i.getName() + "' for '" + b.getBundleId() + "' ");
                }
            }
            return set.stream().map(bb -> new ResolvedBundle((Bundle)bb, true)).collect(Collectors.toSet());
        }).flatMap(bs -> bs.stream()).collect(Collectors.toSet()));
        rv.addAll(b.getRequiredBundles().stream().filter(i -> i.isOptional()).map(i -> {
            List<Bundle> list = this.bundleById.get(i.getName());
            if (list == null) {
                list = new ArrayList<Bundle>();
                if (!(i.isOptional() || i.getName().equals("system.bundle") || i.getName().startsWith("javax"))) {
                    System.err.println("Could not resolve bundle '" + i.getName() + "' for '" + b.getBundleId() + "' ");
                }
            }
            return list.stream().map(bb -> new ResolvedBundle((Bundle)bb, true)).collect(Collectors.toSet());
        }).flatMap(bs -> bs.stream()).collect(Collectors.toSet()));
        return rv.stream().filter(rb -> this.resolvedBundleFilter.test(b, (ResolvedBundle)rb)).collect(Collectors.toSet());
    }

    static String toPomVersion(String version) {
        String[] parts = version.split("\\.");
        return parts[0] + "." + parts[1] + "." + parts[2];
    }

    private void writeLine(OutputStreamWriter w, String v) {
        try {
            w.write(v + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createPom(Bundle b) {
        try (FileOutputStream out = new FileOutputStream(new File(new File(this.workingDirectory, "poms"), b.getBundleId() + ".xml"));
             OutputStreamWriter w = new OutputStreamWriter(out);){
            this.writeLine(w, "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            this.writeLine(w, "\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">");
            this.writeLine(w, "\t<modelVersion>4.0.0</modelVersion>");
            this.writeLine(w, "\t<groupId>" + this.groupIdResolver.apply(b) + "</groupId>");
            this.writeLine(w, "\t<artifactId>" + b.getBundleId() + "</artifactId>");
            this.writeLine(w, "\t<version>" + OsgiToMaven.toPomVersion(b.getVersion()) + (this.snapshotFilter.test(b) ? "-SNAPSHOT" : "") + "</version>");
            this.writeLine(w, "\t<name>" + b.getName() + "</name>");
            this.writeLine(w, "\t<description>" + b.getName() + "</description>");
            this.writeLine(w, "\t<url>" + this.projectUrlResolver.apply(b) + "</url>");
            this.writeLine(w, "\t<licenses>");
            this.licenseResolver.apply(b).forEach(l -> {
                this.writeLine(w, "\t\t<license>");
                this.writeLine(w, "\t\t\t<name>" + l.name + "</name>");
                this.writeLine(w, "\t\t\t<url>" + l.url + "</url>");
                this.writeLine(w, "\t\t</license>");
            });
            this.writeLine(w, "\t</licenses>");
            this.writeLine(w, "\t<scm>");
            this.writeLine(w, "\t\t<url>" + this.scmUrlResolver.apply((Bundle)b).url + "</url>");
            this.scmUrlResolver.apply((Bundle)b).tag.ifPresent(v -> this.writeLine(w, "\t\t<tag>" + v + "</tag>"));
            this.scmUrlResolver.apply((Bundle)b).connection.ifPresent(v -> this.writeLine(w, "\t\t<connection>" + v + "</connection>"));
            this.writeLine(w, "\t</scm>");
            this.writeLine(w, "\t<developers>");
            this.developerResolver.apply(b).forEach(d -> {
                this.writeLine(w, "\t\t<developer>");
                d.url.ifPresent(v -> this.writeLine(w, "\t\t\t<url>" + v + "</url>"));
                d.name.ifPresent(v -> this.writeLine(w, "\t\t\t<name>" + v + "</name>"));
                d.organization.ifPresent(v -> this.writeLine(w, "\t\t\t<organization>" + v + "</organization>"));
                this.writeLine(w, "\t\t</developer>");
            });
            this.writeLine(w, "\t</developers>");
            if (!b.getResolvedBundleDeps().isEmpty()) {
                w.write("\t<dependencies>\n");
                for (ResolvedBundle rd : b.getResolvedBundleDeps()) {
                    MavenDep dep = this.mavenReplacementLookup.apply(rd.getBundle()).orElse(new MavenDep(this.groupIdResolver.apply(rd.getBundle()), rd.getBundle().getBundleId()));
                    w.write("\t\t<dependency>\n");
                    w.write("\t\t\t<groupId>" + dep.groupId + "</groupId>\n");
                    w.write("\t\t\t<artifactId>" + dep.artifactId + "</artifactId>\n");
                    w.write("\t\t\t<version>" + OsgiToMaven.toPomVersion(rd.getBundle().getVersion()) + (this.snapshotFilter.test(rd.getBundle()) ? "-SNAPSHOT" : "") + "</version>\n");
                    if (rd.isOptional()) {
                        w.write("\t\t\t<optional>true</optional>\n");
                    }
                    w.write("\t\t</dependency>\n");
                }
                w.write("\t</dependencies>\n");
            }
            w.write("</project>");
            w.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean exec(String[] cmdArray, FileOutputStream out) throws Throwable {
        if (this.dryRun) {
            out.write((Stream.of(cmdArray).collect(Collectors.joining(" ")) + "\n").getBytes());
            return true;
        }
        ProcessBuilder b = new ProcessBuilder(cmdArray);
        b.inheritIO();
        int waitFor = b.start().waitFor();
        return waitFor == 0;
    }

    private void initMavenIndex() throws PlexusContainerException, ComponentLookupException, ExistingLuceneIndexMismatchException, IllegalArgumentException, IOException {
        if (this.indexer != null) {
            return;
        }
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        DefaultPlexusContainer plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        Indexer indexer = (Indexer)plexusContainer.lookup(Indexer.class);
        IndexUpdater indexUpdater = (IndexUpdater)plexusContainer.lookup(IndexUpdater.class);
        Wagon httpWagon = (Wagon)plexusContainer.lookup(Wagon.class, "http");
        File tempDir = Files.createTempDir();
        File cache = new File(tempDir, "repo-cache");
        File index = new File(tempDir, "repo-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(plexusContainer.lookup(IndexCreator.class, "min"));
        indexers.add(plexusContainer.lookup(IndexCreator.class, "jarContent"));
        indexers.add(plexusContainer.lookup(IndexCreator.class, "maven-plugin"));
        IndexingContext indexContext = indexer.createIndexingContext("repo-context", "repo", cache, index, this.repositoryUrl, null, true, true, indexers);
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(httpWagon, null, null, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(indexContext, (ResourceFetcher)resourceFetcher);
        IndexUpdateResult updateResult = indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (!updateResult.isSuccessful()) {
            throw new RuntimeException("Failed to update index");
        }
        this.indexer = indexer;
        this.indexContext = indexContext;
    }

    private boolean isAvailable(Bundle bundle) {
        if (this.dryRun) {
            return false;
        }
        try {
            this.initMavenIndex();
            Query gQuery = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression(this.groupIdResolver.apply(bundle)));
            Query aQuery = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression(bundle.getBundleId()));
            Query vQuery = this.indexer.constructQuery(MAVEN.VERSION, (SearchExpression)new SourcedSearchExpression(OsgiToMaven.toPomVersion(bundle.getVersion())));
            Query cQuery = this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression("N/P"));
            BooleanQuery bq = new BooleanQuery();
            bq.add(gQuery, BooleanClause.Occur.MUST);
            bq.add(aQuery, BooleanClause.Occur.MUST);
            bq.add(vQuery, BooleanClause.Occur.MUST);
            bq.add(cQuery, BooleanClause.Occur.MUST_NOT);
            FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)bq, this.indexContext));
            return response.getResults().size() > 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean publish(Bundle bundle) throws Throwable {
        if (!this.snapshotFilter.test(bundle) && this.isAvailable(bundle)) {
            System.out.println("\tSkipping '" + bundle.getBundleId() + "' because it is already uploaded");
            return true;
        }
        System.out.print("\tPublishing " + bundle.getBundleId() + " ... ");
        FileOutputStream out = new FileOutputStream(new File(this.workingDirectory, "publish.sh"), true);
        out.write(("\n\necho 'Publishing " + bundle.getBundleId() + "'\n\n").getBytes());
        String javadocDirectory = new File(this.workingDirectory, "javadoc_" + Thread.currentThread().getName()).getAbsolutePath();
        String sourceDirectory = new File(this.workingDirectory, "source_" + Thread.currentThread().getName()).getAbsolutePath();
        String javaDocJar = new File(this.workingDirectory, "javadoc_" + Thread.currentThread().getName() + ".jar").getAbsolutePath();
        this.exec(new String[]{"rm", "-rf", javadocDirectory}, out);
        this.exec(new String[]{"rm", "-rf", sourceDirectory}, out);
        this.exec(new String[]{"rm", "-f", javaDocJar}, out);
        this.exec(new String[]{"mkdir", javadocDirectory}, out);
        this.exec(new String[]{"unzip", "-d", sourceDirectory, new File(this.workingDirectory, bundle.getBundleId() + ".source_" + bundle.getVersion() + ".jar").getAbsolutePath()}, out);
        this.exec(new String[]{"javadoc", "-d", javadocDirectory, "-sourcepath", sourceDirectory, "-subpackages", "."}, out);
        this.exec(new String[]{"jar", "cf", javaDocJar, "-C", javadocDirectory + "/", "."}, out);
        boolean rv = this.exec(new String[]{"mvn", "gpg:sign-and-deploy-file", "-Durl=" + this.repositoryUrl, "-DrepositoryId=" + this.repositoryId, "-DpomFile=" + new File(this.workingDirectory, "/poms/" + bundle.getBundleId() + ".xml").getAbsolutePath(), "-Dfile=" + new File(this.workingDirectory, bundle.getBundleId() + "_" + bundle.getVersion() + ".jar").getAbsolutePath()}, out);
        if (!rv) {
            System.err.println("Failed to publish binary artifact - '" + bundle.getBundleId() + "'");
            return false;
        }
        if (new File(this.workingDirectory, bundle.getBundleId() + ".source_" + bundle.getVersion() + ".jar").exists()) {
            rv = this.exec(new String[]{"mvn", "gpg:sign-and-deploy-file", "-Durl=" + this.repositoryUrl, "-DrepositoryId=" + this.repositoryId, "-DpomFile=" + new File(this.workingDirectory, "/poms/" + bundle.getBundleId() + ".xml").getAbsolutePath(), "-Dfile=" + new File(this.workingDirectory, bundle.getBundleId() + ".source_" + bundle.getVersion() + ".jar").getAbsolutePath(), "-Dclassifier=sources"}, out);
            if (!rv) {
                System.err.println("Failed to publish source artifact - '" + bundle.getBundleId() + "'");
                return false;
            }
            rv = this.exec(new String[]{"mvn", "gpg:sign-and-deploy-file", "-Durl=" + this.repositoryUrl, "-DrepositoryId=" + this.repositoryId, "-DpomFile=" + new File(this.workingDirectory, "/poms/" + bundle.getBundleId() + ".xml").getAbsolutePath(), "-Dfile=" + javaDocJar, "-Dclassifier=javadoc"}, out);
            if (!rv) {
                System.err.println("Failed to publish javadoc artifact - '" + bundle.getBundleId() + "'");
                return false;
            }
        } else {
            System.err.println("No source jar available");
            if (this.sourceEnforced.test(bundle)) {
                return false;
            }
        }
        this.exec(new String[]{"rm", "-rf", javadocDirectory}, out);
        this.exec(new String[]{"rm", "-rf", sourceDirectory}, out);
        this.exec(new String[]{"rm", "-f", javaDocJar}, out);
        out.close();
        System.out.println("done");
        return true;
    }

    private Predicate<Bundle> generatePoms(List<Bundle> bundleList) {
        this.bundleById = bundleList.stream().collect(Collectors.groupingBy(b -> b.getBundleId()));
        this.bundleExports = bundleList.stream().flatMap(i -> i.getExportPackages().stream()).collect(Collectors.groupingBy(e -> e.getName(), Collectors.mapping(e -> e.getBundle(), Collectors.toSet())));
        System.out.print("Resolving bundles ...");
        bundleList.stream().filter(this.bundleFilter).forEach(b -> b.resolve(this::resolve));
        System.out.println("done");
        System.out.print("Generated pom.xml files ...");
        Predicate<Bundle> publishFilter = b -> this.bundleById.containsKey(b.getBundleId() + ".source") || !this.sourceEnforced.test((Bundle)b);
        publishFilter = this.publishFilter.and(publishFilter).and(b -> !this.mavenReplacementLookup.apply((Bundle)b).isPresent());
        bundleList.stream().filter(this.bundleFilter).filter(publishFilter).forEach(this::createPom);
        System.out.println("done");
        return publishFilter;
    }

    public void publish() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(1, r -> {
            Thread thread = new Thread(r, "publish_" + counter.incrementAndGet());
            return thread;
        });
        FileUtils.deleteDirectory((File)this.workingDirectory);
        new File(this.workingDirectory, "poms").mkdirs();
        new File(this.workingDirectory, "m2-repo").mkdirs();
        List<Bundle> bundleList = this.generateBundleList();
        Predicate<Bundle> publishFilter = this.generatePoms(bundleList);
        System.out.println("Publishing bundles ...");
        AtomicBoolean failure = new AtomicBoolean();
        bundleList.stream().filter(this.bundleFilter).filter(publishFilter).forEach(b -> executorService.execute(() -> {
            try {
                if (!failure.get() && !this.publish((Bundle)b)) {
                    failure.set(true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                failure.set(true);
            }
        }));
        executorService.shutdown();
        if (executorService.awaitTermination(4L, TimeUnit.HOURS)) {
            System.out.println("done");
        } else {
            System.out.println("Publishing took too long killing it");
            executorService.shutdownNow();
        }
        FileUtils.deleteDirectory((File)this.workingDirectory);
    }

    public void validate() throws Throwable {
        FileUtils.deleteDirectory((File)this.workingDirectory);
        new File(this.workingDirectory, "poms").mkdirs();
        new File(this.workingDirectory, "m2-repo").mkdirs();
        List<Bundle> bundleList = this.generateBundleList();
        Predicate<Bundle> publishFilter = this.generatePoms(bundleList);
        System.out.print("Validation bundles ...");
        List<Bundle> failures = bundleList.stream().filter(this.bundleFilter).filter(publishFilter).filter(((Predicate<Bundle>)this::validate).negate()).collect(Collectors.toList());
        if (failures.isEmpty()) {
            System.out.println("done");
        } else {
            System.out.println();
            failures.forEach(b -> System.out.println("Resolve failure for '" + b.getBundleId() + "'"));
        }
        FileUtils.deleteDirectory((File)this.workingDirectory);
    }

    private boolean validate(Bundle bundle) {
        try {
            FileOutputStream out = new FileOutputStream(new File(this.workingDirectory, "validate.sh"), true);
            return this.exec(new String[]{"mvn", "dependency:tree", "-f", new File(this.workingDirectory, "/poms/" + bundle.getBundleId() + ".xml").getAbsolutePath(), "-Posgi-validate"}, out);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public abstract List<Bundle> generateBundleList() throws Throwable;

    public static class License {
        public final String name;
        public final String url;

        public License(String name, String url) {
            this.name = name;
            this.url = url;
        }
    }

    public static class SCM {
        public final String url;
        public final Optional<String> tag;
        public final Optional<String> connection;

        public SCM(String url, String tag, String connection) {
            this.url = url;
            this.tag = Optional.ofNullable(tag);
            this.connection = Optional.ofNullable(connection);
        }
    }

    public static class Developer {
        public final Optional<String> url;
        public final Optional<String> name;
        public final Optional<String> organization;

        public Developer(String url, String name, String organization) {
            this.url = Optional.ofNullable(url);
            this.name = Optional.ofNullable(name);
            this.organization = Optional.ofNullable(organization);
        }
    }

    public static class MavenDep {
        public final String groupId;
        public final String artifactId;

        public MavenDep(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }
}

