/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.OsgiToMaven;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureToPom {
    private final File file = Files.createTempDir();
    private File featureJar;

    public FeatureToPom(File featureJar) {
        this.featureJar = featureJar;
    }

    public void publish() throws Exception {
        OsgiToMaven.unzipRepository(this.featureJar, this.file);
        SAXParserFactory instance = SAXParserFactory.newInstance();
        SAXParser parser = instance.newSAXParser();
        SaxHandlerImpl dh = new SaxHandlerImpl();
        parser.parse(new File(this.file, "feature.xml"), (DefaultHandler)dh);
        try (FileOutputStream out = new FileOutputStream(new File(this.file, "poms/" + dh.id + ".xml"));
             OutputStreamWriter w = new OutputStreamWriter(out);){
            w.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            w.write("\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
            w.write("\t<modelVersion>4.0.0</modelVersion>\n");
            w.write("\t<groupId>at.bestsolution.eclipse</groupId>\n");
            w.write("\t<artifactId>" + dh.id + "</artifactId>\n");
            w.write("\t<version>" + OsgiToMaven.toPomVersion(dh.version) + "</version>\n");
            w.write("\t<packaging>pom</packaging>\n");
            w.write("\t<dependencies>\n");
            dh.dep.stream().filter(d -> !((Dep)d).id.endsWith("source")).forEach(d -> {
                try {
                    w.write("\t\t<dependency>\n");
                    w.write("\t\t\t<groupId>at.bestsolution.eclipse</groupId>\n");
                    w.write("\t\t\t<artifactId>" + ((Dep)d).id + "</artifactId>\n");
                    w.write("\t\t\t<version>" + OsgiToMaven.toPomVersion(((Dep)d).version) + "</version>\n");
                    w.write("\t\t</dependency>\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            w.write("\t</dependencies>\n");
            w.write("</project>");
            w.close();
        }
    }

    static class Dep {
        private String id;
        private String version;

        public Dep(String id, String version) {
            this.id = id;
            this.version = version;
        }
    }

    static class SaxHandlerImpl
    extends DefaultHandler {
        private String id;
        private String version;
        private List<Dep> dep = new ArrayList<Dep>();

        SaxHandlerImpl() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("feature")) {
                this.id = attributes.getValue("id");
                this.version = attributes.getValue("version");
            } else if (qName.equals("plugin")) {
                this.dep.add(new Dep(attributes.getValue("id"), attributes.getValue("version")));
            }
        }
    }
}

