/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.publisher;

import at.bestsolution.maven.publisher.ExportPackage;
import at.bestsolution.maven.publisher.ImportPackage;
import at.bestsolution.maven.publisher.RequireBundle;
import at.bestsolution.maven.publisher.ResolvedBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Bundle {
    private String bundleId;
    private String name;
    private String vendor;
    private String version;
    private List<ExportPackage> exportPackages = new ArrayList<ExportPackage>();
    private List<ImportPackage> importPackages = new ArrayList<ImportPackage>();
    private List<RequireBundle> requiredBundles = new ArrayList<RequireBundle>();
    private List<ResolvedBundle> resolvedBundleDeps;

    public String getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<ExportPackage> getExportPackages() {
        return this.exportPackages;
    }

    public List<ImportPackage> getImportPackages() {
        return this.importPackages;
    }

    public List<RequireBundle> getRequiredBundles() {
        return this.requiredBundles;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("bundle " + this.bundleId + "@" + this.version + "{\n");
        b.append("\texports {\n");
        b.append(this.exportPackages.stream().map(e -> e.getName() + "@" + e.getVersion()).collect(Collectors.joining("\n\t\t", "\t\t", "\n")));
        b.append("\t}\n");
        b.append("\timports {\n");
        b.append(this.importPackages.stream().map(e -> (e.isOptional() ? "optional " : "") + e.getName()).collect(Collectors.joining("\n\t\t", "\t\t", "\n")));
        b.append("\t}\n");
        b.append("\trequire-bundle {\n");
        b.append(this.requiredBundles.stream().map(e -> (e.isOptional() ? "optional " : "") + e.getName()).collect(Collectors.joining("\n\t\t", "\t\t", "\n")));
        b.append("\t}\n");
        b.append("}");
        return b.toString();
    }

    public void addExport(ExportPackage currentExport) {
        this.exportPackages.add(currentExport);
        currentExport.setBundle(this);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addImport(ImportPackage currentImport) {
        this.importPackages.add(currentImport);
    }

    public void addRequire(RequireBundle currentRequireBundle) {
        this.requiredBundles.add(currentRequireBundle);
    }

    public void resolve(Function<Bundle, Set<ResolvedBundle>> resolver) {
        if (this.resolvedBundleDeps == null) {
            this.resolvedBundleDeps = new ArrayList<ResolvedBundle>((Collection)resolver.apply(this));
            Collections.sort(this.resolvedBundleDeps, new Comparator<ResolvedBundle>(){

                @Override
                public int compare(ResolvedBundle o1, ResolvedBundle o2) {
                    return o1.getBundle().getBundleId().compareTo(o2.getBundle().getBundleId());
                }
            });
        }
    }

    public List<ResolvedBundle> getResolvedBundleDeps() {
        return this.resolvedBundleDeps == null ? Collections.emptyList() : Collections.unmodifiableList(this.resolvedBundleDeps);
    }
}

