/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.util;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.RouteSegment;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class Utils {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");

    public static ZonedDateTime parseDateTime(String dateTimeString, String variableName) {
        if (dateTimeString == null) {
            throw new IllegalArgumentException(variableName + " must not be null");
        }
        try {
            return ZonedDateTime.parse(dateTimeString).truncatedTo(ChronoUnit.SECONDS);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(variableName + " could not be parsed: " + e.getMessage());
        }
    }

    public static String getDateTimeString(ZonedDateTime time) {
        return FORMATTER.format(time);
    }

    public static String getShortStringDateTime(ZonedDateTime time) {
        return time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String getShortStringDate(ZonedDateTime time) {
        return time.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String getShortStringTime(ZonedDateTime time) {
        return time.format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static boolean isBetween(ZonedDateTime start, Optional<ZonedDateTime> between, ZonedDateTime end) {
        return !between.isPresent() || !start.isAfter(between.get()) && !end.isBefore(between.get());
    }

    public static Set<Constants.GeneralizedModeOfTransportType> parseModesOfTransport(String modesOfTransport, String variableName) {
        if (modesOfTransport == null) {
            throw new IllegalArgumentException(modesOfTransport + " must not be null");
        }
        HashSet<Constants.GeneralizedModeOfTransportType> motSet = new HashSet<Constants.GeneralizedModeOfTransportType>();
        for (String modeOfTransport : modesOfTransport.split(",")) {
            try {
                motSet.add(Constants.GeneralizedModeOfTransportType.valueOf(modeOfTransport.trim().toUpperCase()));
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("'" + modeOfTransport + "' is not a valid mode of transport");
            }
        }
        return motSet;
    }

    public static Location<?> createLocation(double latitude, double longitude) {
        return Location.createMinimal(GeoJSONCoordinate.create(longitude, latitude));
    }

    public static String getJsonString(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(object);
    }

    public static Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingBoxFromGeometryGeoJson(List<RouteSegment> segments) {
        BigDecimal minX = null;
        BigDecimal maxX = null;
        BigDecimal minY = null;
        BigDecimal maxY = null;
        for (RouteSegment segment : segments) {
            if (!segment.getGeometryGeoJson().isPresent()) continue;
            for (GeoJSONCoordinate xy : segment.getGeometryGeoJson().get().getGeometry().getCoordinates()) {
                if (minX == null || minX.compareTo(xy.getX()) > 0) {
                    minX = xy.getX();
                }
                if (maxX == null || maxX.compareTo(xy.getX()) < 0) {
                    maxX = xy.getX();
                }
                if (minY == null || minY.compareTo(xy.getY()) > 0) {
                    minY = xy.getY();
                }
                if (maxY != null && maxY.compareTo(xy.getY()) >= 0) continue;
                maxY = xy.getY();
            }
        }
        if (minX == null || maxX == null || minY == null || maxY == null) {
            return Optional.empty();
        }
        ArrayList<GeoJSONCoordinate> outerRing = new ArrayList<GeoJSONCoordinate>();
        outerRing.add(GeoJSONCoordinate.create(minX, minY));
        outerRing.add(GeoJSONCoordinate.create(minX, maxY));
        outerRing.add(GeoJSONCoordinate.create(maxX, maxY));
        outerRing.add(GeoJSONCoordinate.create(maxX, minY));
        outerRing.add(GeoJSONCoordinate.create(minX, minY));
        return Optional.of(GeoJSONFeature.createPolygonFeatureFromRings(outerRing, Collections.emptyList()));
    }

    public static void checkPositiveIntegerOrEmpty(Optional<Integer> value, String variableName) {
        if (value.isPresent()) {
            Preconditions.checkArgument((value.get() >= 0 ? 1 : 0) != 0, (String)"only positive numbers for %s are allowed, was %s", (Object)variableName, value);
        }
    }

    public static ModeOfTransport getStandardModeOfTransport(Constants.GeneralizedModeOfTransportType type) {
        switch (type) {
            case BICYCLE: {
                return ModeOfTransport.STANDARD_BICYCLE;
            }
            case CAR: {
                return ModeOfTransport.STANDARD_CAR;
            }
            case FOOT: {
                return ModeOfTransport.STANDARD_FOOT;
            }
            case MOTORCYCLE: {
                return ModeOfTransport.STANDARD_MOTORCYCLE;
            }
            case PUBLIC_TRANSPORT: {
                return ModeOfTransport.STANDARD_PUBLIC_TRANSPORT;
            }
        }
        throw new IllegalArgumentException("unsupported type " + (Object)((Object)type));
    }
}

