/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Operator;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class SharingStation
extends Location<SharingStation> {
    private Optional<String> name = Optional.empty();
    private Optional<String> id = Optional.empty();
    private List<Constants.GeneralizedModeOfTransportType> modesOfTransport = new ArrayList<Constants.GeneralizedModeOfTransportType>();
    private Optional<Operator> operator = Optional.empty();

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public List<Constants.GeneralizedModeOfTransportType> getModesOfTransport() {
        return this.modesOfTransport;
    }

    public Optional<Operator> getOperator() {
        return this.operator;
    }

    public SharingStation setName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public SharingStation setId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public SharingStation setModesOfTransport(List<Constants.GeneralizedModeOfTransportType> modesOfTransport) {
        this.modesOfTransport = Lists.newArrayList(modesOfTransport);
        return this;
    }

    public SharingStation setOperator(Operator operator) {
        this.operator = Optional.ofNullable(operator);
        return this;
    }

    public static SharingStation createMinimal(GeoJSONCoordinate position) {
        return (SharingStation)new SharingStation().setCoordinate(position);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.modesOfTransport == null ? 0 : this.modesOfTransport.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharingStation other = (SharingStation)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.modesOfTransport == null ? other.modesOfTransport != null : !this.modesOfTransport.equals(other.modesOfTransport)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
    }

    @Override
    public String toString() {
        return super.toString() + " -> SharingStation [name=" + this.name + ", id=" + this.id + ", modesOfTransport=" + this.modesOfTransport + ", operator=" + this.operator + "]";
    }
}

