/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class RoadCrossingInstruction
extends Instruction<RoadCrossingInstruction> {
    private Constants.TurnDirection turnDirection;
    private Optional<Landmark> landmark = Optional.empty();
    private Optional<Constants.RoadCrossing> roadCrossing = Optional.empty();

    public Constants.TurnDirection getTurnDirection() {
        return this.turnDirection;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Constants.RoadCrossing> getRoadCrossing() {
        return this.roadCrossing;
    }

    public RoadCrossingInstruction setTurnDirection(Constants.TurnDirection turnDirection) {
        this.turnDirection = turnDirection;
        return this;
    }

    public RoadCrossingInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.ofNullable(landmark);
        return this;
    }

    public RoadCrossingInstruction setRoadCrossing(Constants.RoadCrossing roadCrossing) {
        this.roadCrossing = Optional.ofNullable(roadCrossing);
        return this;
    }

    public static RoadCrossingInstruction createMinimal(GeoJSONCoordinate position, Constants.TurnDirection turnDirection) {
        return ((RoadCrossingInstruction)new RoadCrossingInstruction().setPosition(position)).setTurnDirection(turnDirection);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.turnDirection != null ? 1 : 0) != 0, (Object)"turnDirection is mandatory but missing");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.landmark == null ? 0 : this.landmark.hashCode());
        result = 31 * result + (this.roadCrossing == null ? 0 : this.roadCrossing.hashCode());
        result = 31 * result + (this.turnDirection == null ? 0 : this.turnDirection.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoadCrossingInstruction other = (RoadCrossingInstruction)obj;
        if (this.landmark == null ? other.landmark != null : !this.landmark.equals(other.landmark)) {
            return false;
        }
        if (this.roadCrossing == null ? other.roadCrossing != null : !this.roadCrossing.equals(other.roadCrossing)) {
            return false;
        }
        return this.turnDirection == other.turnDirection;
    }

    @Override
    public String toString() {
        return super.toString() + " -> RoadCrossingInstruction [turnDirection=" + (Object)((Object)this.turnDirection) + ", landmark=" + this.landmark + ", roadCrossing=" + this.roadCrossing + "]";
    }
}

