/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPoint;
import at.ac.ait.ariadne.routeformat.instruction.AreaInstruction;
import at.ac.ait.ariadne.routeformat.instruction.ModeChangeInstruction;
import at.ac.ait.ariadne.routeformat.instruction.RoadCrossingInstruction;
import at.ac.ait.ariadne.routeformat.instruction.RoadInstruction;
import at.ac.ait.ariadne.routeformat.instruction.RoundaboutInstruction;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=RoadInstruction.class, name="RoadInstruction"), @JsonSubTypes.Type(value=RoadCrossingInstruction.class, name="RoadCrossingInstruction"), @JsonSubTypes.Type(value=RoundaboutInstruction.class, name="RoundaboutInstruction"), @JsonSubTypes.Type(value=AreaInstruction.class, name="AreaInstruction"), @JsonSubTypes.Type(value=ModeChangeInstruction.class, name="ModeChangeInstruction")})
public abstract class Instruction<T extends Instruction<T>>
implements Validatable {
    private GeoJSONFeature<GeoJSONPoint> position;
    private Optional<GeoJSONFeature<GeoJSONPoint>> previewTriggerPosition = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONPoint>> confirmationTriggerPosition = Optional.empty();
    private Map<String, String> text = new TreeMap<String, String>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public GeoJSONFeature<GeoJSONPoint> getPosition() {
        return this.position;
    }

    public Optional<GeoJSONFeature<GeoJSONPoint>> getPreviewTriggerPosition() {
        return this.previewTriggerPosition;
    }

    public Optional<GeoJSONFeature<GeoJSONPoint>> getConfirmationTriggerPosition() {
        return this.confirmationTriggerPosition;
    }

    public Map<String, String> getText() {
        return this.text;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @JsonProperty
    public T setPosition(GeoJSONFeature<GeoJSONPoint> position) {
        this.position = position;
        return (T)this;
    }

    @JsonIgnore
    public T setPosition(GeoJSONCoordinate position) {
        this.position = GeoJSONFeature.createPointFeature(position);
        return (T)this;
    }

    @JsonProperty
    public T setPreviewTriggerPosition(GeoJSONFeature<GeoJSONPoint> previewTriggerPosition) {
        this.previewTriggerPosition = Optional.ofNullable(previewTriggerPosition);
        return (T)this;
    }

    @JsonIgnore
    public T setPreviewTriggerPosition(GeoJSONCoordinate previewTriggerPosition) {
        this.previewTriggerPosition = Optional.ofNullable(GeoJSONFeature.createPointFeature(previewTriggerPosition));
        return (T)this;
    }

    @JsonProperty
    public T setConfirmationTriggerPosition(GeoJSONFeature<GeoJSONPoint> confirmationTriggerPosition) {
        this.confirmationTriggerPosition = Optional.ofNullable(confirmationTriggerPosition);
        return (T)this;
    }

    @JsonIgnore
    public T setConfirmationTriggerPosition(GeoJSONCoordinate confirmationTriggerPosition) {
        this.confirmationTriggerPosition = Optional.ofNullable(GeoJSONFeature.createPointFeature(confirmationTriggerPosition));
        return (T)this;
    }

    public T setText(Map<String, String> text) {
        this.text = new TreeMap<String, String>(text);
        return (T)this;
    }

    public T setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return (T)this;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.position != null ? 1 : 0) != 0, (Object)"position is mandatory but missing");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.confirmationTriggerPosition == null ? 0 : this.confirmationTriggerPosition.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.previewTriggerPosition == null ? 0 : this.previewTriggerPosition.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instruction other = (Instruction)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.confirmationTriggerPosition == null ? other.confirmationTriggerPosition != null : !this.confirmationTriggerPosition.equals(other.confirmationTriggerPosition)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.previewTriggerPosition == null ? other.previewTriggerPosition != null : !this.previewTriggerPosition.equals(other.previewTriggerPosition)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "Instruction [position=" + this.position + ", previewTriggerPosition=" + this.previewTriggerPosition + ", confirmationTriggerPosition=" + this.confirmationTriggerPosition + ", text=" + this.text + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

