/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class GeoJSONFeatureCollection<T extends GeoJSONGeometryObject>
implements Validatable {
    @JsonProperty(required=true)
    public final String type = GeoJSONUtil.getTypeName(this.getClass());
    private List<GeoJSONFeature<T>> features = new ArrayList<GeoJSONFeature<T>>();

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(required=true)
    public List<GeoJSONFeature<T>> getFeatures() {
        return this.features;
    }

    public GeoJSONFeatureCollection<T> setFeatures(List<GeoJSONFeature<T>> features) {
        this.features = new ArrayList<GeoJSONFeature<T>>(features);
        return this;
    }

    public static <T extends GeoJSONGeometryObject> GeoJSONFeatureCollection<T> create(List<GeoJSONFeature<T>> features) {
        return new GeoJSONFeatureCollection<T>().setFeatures(features);
    }

    @Override
    public void validate() {
        this.features.forEach(f -> f.validate());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJSONFeatureCollection other = (GeoJSONFeatureCollection)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public List<String> toWKT() {
        return this.features.stream().map(f -> f.toWKT()).collect(Collectors.toList());
    }

    public String toString() {
        return "GeoJSONFeatureCollection [featuresWKT=" + this.toWKT() + "]";
    }
}

