/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Validatable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Service
implements Validatable {
    private String name;
    private Optional<String> towards = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public Optional<String> getTowards() {
        return this.towards;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Service setName(String name) {
        this.name = name;
        return this;
    }

    public Service setTowards(String towards) {
        this.towards = Optional.ofNullable(towards);
        return this;
    }

    public Service setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Service createMinimal(String name) {
        return new Service().setName(name);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"name is mandatory but missing");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.towards == null ? 0 : this.towards.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.towards == null ? other.towards != null : !this.towards.equals(other.towards));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name == null ? "null" : this.name);
        this.towards.ifPresent(t -> builder.append(" -> " + t));
        return builder.toString();
    }
}

