/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Route;
import at.ac.ait.ariadne.routeformat.RoutingRequest;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class RoutingResponse
implements Validatable {
    private String routeFormatVersion;
    private String requestId;
    private ZonedDateTime processedTime;
    private Constants.Status status;
    private Optional<String> debugMessage = Optional.empty();
    private String coordinateReferenceSystem;
    private Optional<RoutingRequest> request = Optional.empty();
    private List<Route> routes = new ArrayList<Route>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getRouteFormatVersion() {
        return this.routeFormatVersion;
    }

    @JsonProperty(required=true)
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(required=true)
    public String getProcessedTime() {
        return Utils.getDateTimeString(this.processedTime);
    }

    @JsonIgnore
    public ZonedDateTime getProcessedTimeAsZonedDateTime() {
        return this.processedTime;
    }

    @JsonProperty(required=true)
    public Constants.Status getStatus() {
        return this.status;
    }

    public Optional<String> getDebugMessage() {
        return this.debugMessage;
    }

    @JsonProperty(required=true)
    public String getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public Optional<RoutingRequest> getRequest() {
        return this.request;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @JsonProperty(required=true)
    public List<Route> getRoutes() {
        return this.routes;
    }

    public RoutingResponse setRouteFormatVersion(String routeFormatVersion) {
        this.routeFormatVersion = routeFormatVersion;
        return this;
    }

    public RoutingResponse setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RoutingResponse setProcessedTimeNow() {
        this.processedTime = ZonedDateTime.now();
        return this;
    }

    @JsonIgnore
    public RoutingResponse setProcessedTime(ZonedDateTime processedTime) {
        this.processedTime = processedTime;
        return this;
    }

    @JsonProperty
    public RoutingResponse setProcessedTime(String processedTime) {
        this.processedTime = Utils.parseDateTime(processedTime, "processedTime");
        return this;
    }

    public RoutingResponse setStatus(Constants.Status status) {
        this.status = status;
        return this;
    }

    public RoutingResponse setDebugMessage(String debugMessage) {
        this.debugMessage = Optional.ofNullable(debugMessage);
        return this;
    }

    public RoutingResponse setCoordinateReferenceSystem(String coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        return this;
    }

    public RoutingResponse setDefaultCoordinateReferenceSystem() {
        this.coordinateReferenceSystem = "EPSG:4326";
        return this;
    }

    public RoutingResponse setRequest(RoutingRequest request) {
        this.request = Optional.ofNullable(request);
        return this;
    }

    public RoutingResponse setRoutes(List<Route> routes) {
        this.routes = new ArrayList<Route>(routes);
        return this;
    }

    public RoutingResponse setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.routeFormatVersion != null ? 1 : 0) != 0, (Object)"routeFormatVersion is mandatory but missing");
        Preconditions.checkArgument((this.requestId != null ? 1 : 0) != 0, (Object)"requestId is mandatory but missing");
        Preconditions.checkArgument((this.processedTime != null ? 1 : 0) != 0, (Object)"processedTime is mandatory but missing");
        Preconditions.checkArgument((this.status != null ? 1 : 0) != 0, (Object)"status is mandatory but missing");
        Preconditions.checkArgument((this.coordinateReferenceSystem != null ? 1 : 0) != 0, (Object)"coordinateReferenceSystem is mandatory but missing");
        Preconditions.checkArgument((boolean)this.coordinateReferenceSystem.startsWith("EPSG:"), (Object)"coordinateReferenceSystem must start with EPSG:");
        this.request.ifPresent(r -> r.validate());
        this.routes.forEach(r -> r.validate());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.coordinateReferenceSystem == null ? 0 : this.coordinateReferenceSystem.hashCode());
        result = 31 * result + (this.debugMessage == null ? 0 : this.debugMessage.hashCode());
        result = 31 * result + (this.processedTime == null ? 0 : this.processedTime.hashCode());
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 31 * result + (this.requestId == null ? 0 : this.requestId.hashCode());
        result = 31 * result + (this.routeFormatVersion == null ? 0 : this.routeFormatVersion.hashCode());
        result = 31 * result + (this.routes == null ? 0 : this.routes.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingResponse other = (RoutingResponse)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.coordinateReferenceSystem == null ? other.coordinateReferenceSystem != null : !this.coordinateReferenceSystem.equals(other.coordinateReferenceSystem)) {
            return false;
        }
        if (this.debugMessage == null ? other.debugMessage != null : !this.debugMessage.equals(other.debugMessage)) {
            return false;
        }
        if (this.processedTime == null ? other.processedTime != null : !this.processedTime.equals(other.processedTime)) {
            return false;
        }
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        if (this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId)) {
            return false;
        }
        if (this.routeFormatVersion == null ? other.routeFormatVersion != null : !this.routeFormatVersion.equals(other.routeFormatVersion)) {
            return false;
        }
        if (this.routes == null ? other.routes != null : !this.routes.equals(other.routes)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return "RoutingResponse [requestId=" + this.requestId + ", processedTime=" + this.processedTime + ", status=" + (Object)((Object)this.status) + ", routes=" + this.routes.size() + "]";
    }
}

